package jp.ill.photon.util;

import java.util.HashMap;
import java.util.Map;

import jp.ill.photon.dto.ActionDto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class CacheUtil {

    public static String getCacheKeyJsonString(Map<String, Object> cacheKeys, ActionDto dto) {

        try {
            // キャッシュキー対象モジュールパラメータ->URLのParameter、の順で組み立てる
            Map<String, Object> cacheKeyMap = new HashMap<String, Object>();

            // キャッシュキー対象モジュールパラメータ
            for (String key : cacheKeys.keySet()) {
                Object obj = ParamUtil.getParamValueByType(
    					String.valueOf(((Map) cacheKeys.get(key)).get("transfer_type")),
    					((Map) cacheKeys.get(key))
    							.get("transfer_val"),
    					dto);
                cacheKeyMap.put(key,  obj);
            }

            // URLパラメータ
            cacheKeyMap.putAll(dto.getRawParams());

            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString(cacheKeyMap);

            return json;
        } catch (JsonProcessingException ex) {
            return "";
        }
    }

}
