package jp.ill.photon.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayUtil {

	public static String[] rest(String[] arr) {
		if (arr == null || arr.length <= 1) {
			return new String[0];
		}

		return Arrays.<String> copyOfRange(arr, 1, arr.length);
	}

	public static List<String> asList(String[] arr) {
		if (arr == null || arr.length == 0) {
			return new ArrayList<String>();
		}

		return Arrays.<String> asList(arr);
	}

	public static List<Object> asList(Object[] arr) {
		if (arr == null || arr.length == 0) {
			return new ArrayList<Object>();
		}

		return Arrays.<Object> asList(arr);
	}

	public static List<?> asList(Object obj) {
		if (obj == null
				|| (!(obj instanceof String[])) && !(obj instanceof Object[])) {
			return new ArrayList<String>();
		}

		if (obj instanceof String[]) {
			String[] arr = (String[]) obj;

			if (arr.length == 0) {
				return new ArrayList<String>();
			}

			return Arrays.<String> asList(arr);
		} else {
			Object[] arr = (Object[]) obj;

			if (arr.length == 0) {
				return new ArrayList<Object>();
			}

			return Arrays.<Object> asList(arr);
		}
	}

	public static List<?> asListForcing(Object obj) {
		if (obj == null) {
			return new ArrayList<>();
		}

		return Arrays.asList(obj);
	}

	public static List<?> asListForcing(String obj) {
		if (obj == null) {
			return new ArrayList<>();
		}

		return Arrays.asList(obj);
	}

	public static List<?> asListForcing(String[] obj) {
		if (obj == null) {
			return new ArrayList<>();
		}

		return Arrays.asList(obj);
	}

	public static List<?> asListForcing(List<?> obj) {
		if (obj == null) {
			return new ArrayList<>();
		}

		return obj;
	}
	
	public static boolean asListNotEmpty(List<?> obj) {
		if (obj == null || obj.size() == 0) {
			return false;
		}

		return true;
	}
}
