package jp.ill.photon.util;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

/**
 * Action用ユーティリティクラス
 *
 * @author m_fukukawa
 */
public class ActionUtil {

	/**
	 * パラメータ取得<br>
	 *
	 * @param req リクエスト
	 * @param key Mapping ListのKey
	 * @param delimiter 値と値の区切り
	 * @return ret 取得したパラメータ
	 */
	public static String getActionParamString(	Map<String, Object> req,
												String key,
												String delimiter) {
		return getActionParamString(req, key, delimiter, 0, false);
	}

	/**
	 * パラメータ取得<br>
	 *
	 * @param req リクエスト
	 * @param key Mapping ListのKey
	 * @param delimiter 値と値の区切り
	 * @param inputType 入力タイプ
	 * @param quote クォートするかどうか
	 * @return ret 取得したパラメータ
	 */
	public static String getActionParamString(	Map<String, Object> req,
												String key,
												String delimiter,
												Integer inputType,
												boolean quote) {

		StringBuffer ret = new StringBuffer();

		String[] params = getActionParams(req, key);

		if (params == null) {
			return null;
		}

		try {

			for (int i = 0; i < params.length; i++) {
				if (ret.length() != 0) {
					ret.append(delimiter);
				}
				String value = params[i];
				if (!StringUtils.isEmpty(value)) {
					if (quote) {
						value = "$$" + value + "$$";
					}
					ret.append(value);
				}
			}

		} catch (Exception e) {
			return req.get(key).toString();
		}

		return ret.toString();

	}

	/**
	 * パラメータ取得<br>
	 *
	 * @param req リクエスト
	 * @param key Mapping ListのKey
	 * @return ret 取得したパラメータ
	 */
	public static String[] getActionParams(Map<String, Object> req,
											String key) {
		return ((String[]) req.get(key));
	}

}
