package jp.ill.photon.struts.thymeleaf;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;

import jp.ill.photon.action.GeneralAction;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsConstants;
import org.thymeleaf.TemplateEngine;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;

public class ThymeleafResult implements Result {
	private String defaultEncoding = "UTF-8";
	private TemplateEngineFactory templateEngineFactory;
	private String templateName;

	/**
	 * The result parameter name to set the name of the template to. IMPORTANT!
	 * Struts2 will look for this field reflectively to determine which
	 * parameter is the default. This allows us to have a simplified result
	 * configuration. Don't remove it!
	 */
	public static final String DEFAULT_PARAM = "templateName";

	public ThymeleafResult() {
	}

	public ThymeleafResult(String templateName) {
		this.templateName = templateName;
	}

	@Override
	public void execute(ActionInvocation invocation) throws Exception {
		TemplateEngine templateEngine = templateEngineFactory.get();

		GeneralAction action = (GeneralAction) invocation.getAction();
		AECHttpServletRequestWrapper requestWrapper = new AECHttpServletRequestWrapper();
		requestWrapper.setHttpServletRequest(ServletActionContext.getRequest());
		requestWrapper.setOrgContextPath(ServletActionContext.getRequest().getContextPath());
		requestWrapper
				.setContextPath(String
						.valueOf(action.getDto().getAction()
								.getOrDefault("url_root", "/"))
						.replaceAll("/[^/]+$", ""));

		HttpServletResponse response = ServletActionContext.getResponse();
		ServletContext servletContext = ServletActionContext
				.getServletContext();

		Context context = new Context(requestWrapper,
				ServletActionContext.getRequest(), response, servletContext,
				invocation);
		response.setContentType("text/html");
		response.setCharacterEncoding(defaultEncoding);
		templateEngine.process(conditionalParse(templateName, invocation),
				context, response.getWriter());

	}

	@Inject(StrutsConstants.STRUTS_I18N_ENCODING)
	public void setDefaultEncoding(String defaultEncoding) {
		this.defaultEncoding = defaultEncoding;
	}

	@Inject
	public void setTemplateEngineFactory(TemplateEngineFactory templateEngineFactory) {
		this.templateEngineFactory = templateEngineFactory;
	}

	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}

	protected String conditionalParse(	String param,
										ActionInvocation invocation) {
		if (param != null && invocation != null) {
			return TextParseUtil.translateVariables(param,
					invocation.getStack(), new EncodingParsedValueEvaluator());
		} else {
			return param;
		}
	}

	private final class EncodingParsedValueEvaluator
			implements TextParseUtil.ParsedValueEvaluator {
		public Object evaluate(String parsedValue) {
			return parsedValue;
		}
	}
}
