package jp.ill.photon.struts.thymeleaf;

import java.util.Map;

import jp.ill.photon.action.GeneralAction;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.validation.SingleValidator;
import jp.ill.photon.util.DateFormatCheckUtil;
import jp.ill.photon.util.DateUtil;
import jp.ill.photon.util.StringFormatUtil;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PhotonFormatUtility extends AbstractPhotonBaseUtility {

	/**
	 *
	 * フォーマット（カンマ付）
	 *
	 * @param value
	 * @return フォーマットされた値
	 */
	public static String num(String value) {
		return StringFormatUtil.num(value);
	}

	/**
	 *
	 * フォーマット（カンマ無）
	 *
	 * @param value
	 * @return フォーマットされた値
	 */
	public static String numnc(String value) {
		return StringFormatUtil.numnc(value);
	}

	public String dateFromDateTime(String value) {
		if (StringUtils.isEmpty(value)) {
			return value;
		}

		String[] dateTimeSet = value.split(" ");
		if (dateTimeSet.length >= 1) {
			return dateTimeSet[0];
		} else {
			return value;
		}
	}

	public String timeFromDateTime(String value) {
		if (StringUtils.isEmpty(value)) {
			return value;
		}

		String[] dateTimeSet = value.split(" ", -1);
		if (dateTimeSet.length >= 2) {
			return dateTimeSet[1];
		} else {
			return value;
		}
	}

	/**
	 *
	 * フォーマット（カンマ付）
	 *
	 * @param value
	 * @return フォーマットされた値
	 */
	public static String money(String value) {
		return StringFormatUtil.money(value);
	}

	/**
	 * 引数のカレンダーを指定のフォーマットで返す（YYYY-MM-DD）
	 *
	 * @return String YYYY-MM-DD
	 */
	public static String formatDate(String str) {
		return DateUtil.formatDate(str);
	}

	/**
	 * 引数のカレンダーを指定のフォーマットで返す（YYYY-MM-DD HH24:MI）
	 *
	 * @return String YYYY-MM-DD HH24:MI
	 */
	public String formatDateTimeToMinute(String str) {
		return DateUtil.formatDateTimeToMinute(str);
	}

	/**
	 * 引数のカレンダーを指定のフォーマットで返す（YYYY-MM-DD HH24:MI:SS）
	 *
	 * @return String YYYY-MM-DD HH24:MI:SS
	 */
	public static String formatDateTimeToSecond(String str) {
		return DateUtil.formatDateTimeToSecond(str);
	}

	/***
	 * バリデーションチェックして、falseだったら空白、trueだったらvalueを表示する
	 *
	 * @param value
	 * @param validationSetId
	 * @return
	 */
	public String outputValueByValidator(String value, String validationSetId) {

		if (!StringUtils.isEmpty(validationSetId)) {

			// contextから、ActionDtoを作成
			GeneralAction action = (GeneralAction) getContext()
					.getVariable("action");
			ActionDto dto = action.getDto();
			String tenantId = dto.getTenantId();

			dto.setParams(action.getParams());
			dto.setDataMap(dto.getDataMap());

			SingleValidator validator = new SingleValidator(tenantId,
					validationSetId, "");

			Map<String, Object> errors = validator.validate("target_value",
					"対象の値", value, dto);

			// バリデーションエラーがあった場合は空白を返却
			if (!errors.isEmpty()) {
				return "";
			}

		}

		return value;

	}

	/***
	 * 日付日時のフォーマットチェックして、falseだったら空白、trueだったらvalueを表示する
	 *
	 * @param value
	 * @param type
	 * @return
	 */
	public String outputValueDate(String value, String type) {

		// 日付フォーマットチェック
		if (!DateFormatCheckUtil.dateFormatCheck(type, value)) {
			return "";
		}
		return value;

	}

	/**
	 * 0埋め処理.
	 *
	 * @param str
	 * @param length
	 * @return
	 */
	public static String zeroPadding(String str, int length) {

		if (str == null || str.length() == 0 || str.length() > length) {
			return str;
		}

		StringBuffer sb = new StringBuffer();
		for (int i = str.length(); i < length; i++) {
			sb.append("0");
		}
		sb.append(str);
		return sb.toString();
	}

	/**
	 * 0埋め処理かフォーマット（カンマ付）
	 * 利用者側_注文・見積確認画面で使用中
	 *
	 * @param str
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static String zeroPaddingOrNum(Map<String, Object> exfieldMap, String val) {

		if (!MapUtils.isEmpty(exfieldMap)) {

			String textDataFormat = (String) exfieldMap.get("text_data_format");
			String type = (String) exfieldMap.get("type");
			String textHalfZeroFillFlg = (String) exfieldMap.get("text_half_zero_fill_flg");
			Map<String, Object> htmlAttr = (Map<String, Object>) exfieldMap.get("html_attr");
			String maxLengthStr = (String) htmlAttr.get("maxlength");

			if("2".equals(textDataFormat) && "text".equals(type)) {

				return StringFormatUtil.num(val);

			} else if ("1".equals(textHalfZeroFillFlg) && "text".equals(type)) {

				if (maxLengthStr != null) {

					int maxLength = new Integer(maxLengthStr).intValue();
					return zeroPadding(val, maxLength);

				}

			}

		}

		return val;

	}



}
