package jp.ill.photon.struts.thymeleaf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.expression.IExpressionObjectFactory;

public class PhotonExpressionObjectFactory implements IExpressionObjectFactory {

	private Map<String, Object> expressionObjects = null;

	public PhotonExpressionObjectFactory() {
		expressionObjects = new HashMap<String, Object>();
		expressionObjects.put("pu", new PathUtility());
		expressionObjects.put("dto", new DTOUtility());
		expressionObjects.put("aov", new AoRoundingUtility());
		expressionObjects.put("fmt", new PhotonFormatUtility());
		expressionObjects.put("form", new FormUtility());
		expressionObjects.put("util", new Utility());

		expressionObjects.put("div", new DivisionUtility());
	}

	@Override
	public Object buildObject(	IExpressionContext context,
								String expressionObjectName) {
		AbstractPhotonBaseUtility utility = (AbstractPhotonBaseUtility) this.expressionObjects
				.getOrDefault(expressionObjectName, null);
		utility.setContext(context);
		return utility;
	}

	@Override
	public Set<String> getAllExpressionObjectNames() {
		// TODO Auto-generated method stub
		return this.expressionObjects.keySet();
	}

	@Override
	public boolean isCacheable(String arg0) {
		// TODO Auto-generated method stub
		return false;
	}

}
