package jp.ill.photon.struts.thymeleaf;

import java.util.LinkedHashSet;
import java.util.Set;

import org.thymeleaf.dialect.IExpressionObjectDialect;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.processor.IProcessor;

public class PhotonDialect
		implements IExpressionObjectDialect, IProcessorDialect {

	private PhotonExpressionObjectFactory factory;

	protected PhotonDialect() {
		this.factory = new PhotonExpressionObjectFactory();
	}

	@Override
	public String getName() {
		return "PhotonDialect";
	}

	@Override
	public IExpressionObjectFactory getExpressionObjectFactory() {
		return this.factory;
	}

	@Override
	public String getPrefix() {
		return "ph";
	}

	@Override
	public int getDialectProcessorPrecedence() {
		return 1000;
	}

	@Override
	public Set<IProcessor> getProcessors(String dialectPrefix) {
		Set<IProcessor> processors = new LinkedHashSet<IProcessor>();
		processors.add(new HtmlAttrProcessor(dialectPrefix));

		return processors;
	}

}
