/**
 *
 */
package jp.ill.photon.struts.thymeleaf;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;

/**
 * @author m_fukukawa
 *
 */
public class HtmlAttrProcessor extends AbstractAttributeTagProcessor {

	/** プロセッサの優先度 */
	public static final int ATTR_PRECEDENCE = 10000;
	/** タグ名 */
	public static final String ATTR_NAME = "htmlattr";
	/** 除外HTML属性リスト */
	private String[] excludeAttrList = new String[] { "name", "value" };
	/** 追記HTML属性リスト */
	private String[] appendAttrList = new String[] { "style", "class" };

	public HtmlAttrProcessor(final String dialectPrefix) {
		super(TemplateMode.HTML, // This processor will apply only to HTML mode
				dialectPrefix, // Prefix to be applied to name for matching
				null, // No tag name: match any tag name
				false, // No prefix to be applied to tag name
				ATTR_NAME, // Name of the attribute that will be matched
				true, // Apply dialect prefix to attribute name
				ATTR_PRECEDENCE, // Precedence (inside dialect's own precedence)
				true); // Remove the matched attribute afterwards
	}

	@Override
	protected void doProcess(	ITemplateContext context,
								IProcessableElementTag tag,
								AttributeName attributeName,
								String attributeValue,
								IElementTagStructureHandler structureHandler) {
		// 渡されたマップのkeyをhtmlの属性、valueを属性値として出力する。
		// ・"name"、"value"属性に関する設定は除外する。
		// ・"class"、"style"属性だけは、上書きではなく、追記とする。

		final IEngineConfiguration configuration = context.getConfiguration();
		final IStandardExpressionParser expressionParser = StandardExpressions
				.getExpressionParser(configuration);

		final IStandardExpression expression = expressionParser
				.parseExpression(context, attributeValue);

		final Object valueForAttributes = expression.execute(context,
				StandardExpressionExecutionContext.NORMAL);
		Map<String, String> result = new HashMap<String, String>();
		if (valueForAttributes != null) {
			Map<String, String> workAttrs = (Map<String, String>) valueForAttributes;
			for (Map.Entry<String, String> e : workAttrs.entrySet()) {
				if (Arrays.asList(excludeAttrList).contains(e.getKey())) {
					// 除外
					continue;
				} else if (Arrays.asList(appendAttrList).contains(e.getKey())) {
					// 追記
					String val = StringUtils.defaultString(
							tag.getAttributeValue(e.getKey()), "");
					val += (StringUtils.isEmpty(val) ? "" : " ") + e.getValue();
					result.put(e.getKey(), val);
				} else {
					// そのまま出力
					result.put(e.getKey(), e.getValue());
				}
			}
			// result = (Map<String,String>)valueForAttributes;
		}

		for (Map.Entry<String, String> entry : result.entrySet()) {
			structureHandler.setAttribute(entry.getKey(), entry.getValue());
		}
	}
}
