package jp.ill.photon.struts.thymeleaf;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.util.LogUtil;

public class FormUtility extends AbstractPhotonBaseUtility {

	public static class FormItemTypes {
		public static final String TYPE_LABEL = "label";
		public static final String TYPE_TEXT = "text";
		public static final String TYPE_CHECKBOX = "checkbox";
		public static final String TYPE_RADIO = "radio";
		public static final String TYPE_COMBOBOX = "combobox";
		public static final String TYPE_LISTBOX = "listbox";
		public static final String TYPE_TEXTAREA = "textarea";
		public static final String TYPE_FILE = "file";
		public static final String TYPE_FILE_MULTI = "file_multi";
		public static final String TYPE_DATE = "date";
		public static final String TYPE_DATETIME = "datetime";
		public static final String TYPE_RICHTEXT = "richtext";
		public static final String TYPE_FOREIGN = "foreign";
		public static final String TYPE_FOREIGN_MULTI = "foreign_multi";
		public static final String TYPE_JSON = "json";
		public static final String TYPE_HIDDEN = "hidden";

		public static final String TYPE_RANGE_TEXT = "range_text";
		public static final String TYPE_RANGE_NUMBER = "range_number";
		public static final String TYPE_RANGE_DATE = "range_date";
		public static final String TYPE_RANGE_DATETIME = "range_datetime";
	}

	private Map<String, Map<String, String>> formTypeItemTypeMap;

	public FormUtility() {
		formTypeItemTypeMap = new HashMap<>();

		FormItemTypes types = new FormItemTypes();
		List<String> itemTypes = new ArrayList<>();
		try {
			for (Field field : FormItemTypes.class.getDeclaredFields()) {
				itemTypes.add(String.valueOf(field.get(types)));
			}
		} catch (IllegalArgumentException e) {
			logger.error("カラム取得時エラー", e);
		} catch (IllegalAccessException e) {
			logger.error("カラム取得時エラー", e);
		}

		// 検索フォーム用タイプ設定
		Map<String, String> searchForm = new HashMap<>();
		for (String typeName : itemTypes) {
			switch (typeName) {
			case FormItemTypes.TYPE_TEXTAREA:
				searchForm.put(typeName, FormItemTypes.TYPE_TEXT);
				break;
			case FormItemTypes.TYPE_RICHTEXT:
				searchForm.put(typeName, FormItemTypes.TYPE_TEXT);
				break;
			case FormItemTypes.TYPE_DATE:
				searchForm.put(typeName, FormItemTypes.TYPE_RANGE_DATE);
				break;
			case FormItemTypes.TYPE_DATETIME:
				searchForm.put(typeName, FormItemTypes.TYPE_RANGE_DATETIME);
				break;
			default:
				searchForm.put(typeName, typeName);
			}
		}

		formTypeItemTypeMap.put("search", searchForm);
	}

	public String getTypeByFormType(String formType,
									String itemType,
									String textDataFormat) {
		if (formType == null || formType.length() == 0
				|| !formTypeItemTypeMap.containsKey(formType)) {
			return itemType;
		}

		if (itemType == null) {
			return itemType;
		}

		Map<String, String> formTypeSetting = formTypeItemTypeMap.get(formType);
		String newItemType = formTypeSetting.getOrDefault(itemType, itemType);

		if (textDataFormat != null && textDataFormat.equals("2")) {
			if (formType.equals("search")
					&& newItemType.equals(FormItemTypes.TYPE_TEXT)) {
				newItemType = FormItemTypes.TYPE_RANGE_NUMBER;
			}
		}

		return newItemType;
	}

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(FormUtility.class);
}
