package jp.ill.photon.struts.thymeleaf;

import java.util.HashMap;
import java.util.Map;

import org.thymeleaf.context.IContext;

public class DivisionUtility extends AbstractPhotonBaseUtility {

	private Map<String, Object> divisionNames;

	@Override
	public void setContext(IContext context) {
		super.setContext(context);
		Map<String, Object> map = (Map<String, Object>) context
				.getVariable("division_name");

		if (map != null) {
			divisionNames = (Map<String, Object>) map.get("map");
		}

		if (divisionNames == null) {
			divisionNames = new HashMap<String, Object>();
		}
	}

	public Object disp_name(String division_id, String value) {

		Map<String, Object> map = (Map<String, Object>) divisionNames
				.get(division_id + "_" + value);

		if (map != null) {
			return map.get("name");
		} else {
			return null;
		}
	}

}
