package jp.ill.photon.struts.thymeleaf;

import javax.servlet.ServletContext;

import org.apache.struts2.ServletActionContext;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;

import nz.net.ultraq.thymeleaf.LayoutDialect;

public class DefaultTemplateEngineFactory implements TemplateEngineFactory {

	private TemplateEngine templateEngine;

	@Override
	public TemplateEngine get() {
		if (templateEngine == null) {
			ServletContext servletContext = ServletActionContext
					.getServletContext();
			ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver(
					servletContext);
			templateResolver.setTemplateMode("HTML");
			templateResolver.setCharacterEncoding("UTF-8");
			templateResolver.setPrefix("");
			templateResolver.setSuffix("");
			templateResolver.setCacheable(true);
			templateResolver.setCacheTTLMs(30000L);

			templateEngine = new TemplateEngine();
			templateEngine.setTemplateResolver(templateResolver);
			templateEngine.setMessageResolver(new StandardMessageResolver());

			// レイアウト用ダイアレクトを追加
			templateEngine.addDialect(new LayoutDialect());

			// AECユーティリティダイアレクトを追加
			templateEngine.addDialect(new PhotonDialect());
		}

		return templateEngine;
	}

}
