package jp.ill.photon.struts.thymeleaf;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class DTOUtility extends AbstractPhotonBaseUtility {

	public Object get(Map map, String path) {
		return getValueFromPath(map, path);
	}

	/**
	 * パスを解析してパスから値を取得する
	 * 
	 * @param path
	 * @return
	 */
	protected Object getValueFromPath(Map map, String path) {
		if (path == null) {
			return "";
		}

		String[] keyTree = path.split("\\.");
		String lastKey = null;
		if (keyTree.length == 0) {
			lastKey = path;
		} else {
			lastKey = keyTree[keyTree.length - 1];
			keyTree = Arrays.copyOf(keyTree, keyTree.length - 1);
		}

		if (lastKey == null) {
			return "";
		}

		Map<String, Object> targetMap = map;
		for (String key : keyTree) {
			if (targetMap == null) {
				targetMap = new LinkedHashMap<>();
			}

			if (!targetMap.containsKey(key)) {
				targetMap.put(key, new LinkedHashMap<>());
			}

			targetMap = (Map<String, Object>) targetMap.get(key);
		}

		if (targetMap != null && targetMap.containsKey(lastKey)) {
			return targetMap.get(lastKey);
		} else {
			return "";
		}
	}

}
