package jp.ill.photon.struts.thymeleaf;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.ill.photon.action.GeneralAction;

import org.thymeleaf.context.AbstractContext;
import org.thymeleaf.context.IWebContext;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.LocaleProvider;

public class Context extends AbstractContext implements IWebContext {
	public static final String ACTION_VARIABLE_NAME = "action";

	private final Object action;

	private ServletContext servletContext;

	private HttpServletResponse response;

	private HttpServletRequest request;

	private HttpSession session;

	public Context(AECHttpServletRequestWrapper requestWrapper,
			HttpServletRequest request, HttpServletResponse response,
			ServletContext servletContext, ActionInvocation actionInvocation) {

		this.servletContext = servletContext;
		// this.request = request;
		this.request = requestWrapper;
		this.response = response;
		this.session = requestWrapper.getSession();

		GeneralAction action = (GeneralAction) actionInvocation.getAction();

		this.action = action;

		if (action instanceof LocaleProvider) {
			setLocale(((LocaleProvider) action).getLocale());
		}

		setVariables(action.getDto().getDataMap());
		setVariable("tenantId", action.getTenantId());
		setVariable(ACTION_VARIABLE_NAME, this.action);
	}

	public Object getAction() {
		return action;
	}

	@Override
	public HttpServletRequest getRequest() {
		return request;
	}

	@Override
	public HttpServletResponse getResponse() {
		return response;
	}

	@Override
	public ServletContext getServletContext() {
		return servletContext;
	}

	@Override
	public HttpSession getSession() {
		return session;
	}
}
