package jp.ill.photon.struts.thymeleaf;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.thymeleaf.context.IContext;

import jp.ill.photon.util.AoUtil;

public class AoRoundingUtility extends AbstractPhotonBaseUtility {

	private Map<String, Object> aladdinSetting;

	@Override
	public void setContext(IContext context) {
		super.setContext(context);
		Map<String, Object> commonSettings = (Map<String, Object>) context
				.getVariable("common");

		if (commonSettings == null) {
			aladdinSetting = new HashMap<>();
		} else {
			aladdinSetting = (Map<String, Object>) commonSettings
					.get("aladdinsetting");
		}
	}

	protected static final String VALUE_FIELD = "value";

	/**
	 *
	 * 売上単価フォーマット
	 *
	 * @param value
	 * @param user
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	public Object sales_unit_price(	String value,
									Map<String, Object> user,
									Map<String, Object> aladdinSetting) {
		return getAoRoundedSalesUnitPriceValue(value, user, aladdinSetting);
	}

	public Object sales_unit_price(String value, Map<String, Object> user) {
		return getAoRoundedSalesUnitPriceValue(value, user, aladdinSetting);
	}

	public Object sales_price(	String value,
								Map<String, Object> user,
								Map<String, Object> aladdinSetting) {
		return getAoRoundedSalesPriceValue(value, user, aladdinSetting);
	}

	public Object sales_price(String value, Map<String, Object> user) {
		return getAoRoundedSalesPriceValue(value, user, aladdinSetting);
	}

	/**
	 *
	 * 在庫数フォーマット
	 *
	 * @param value
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	public Object stock_quantity(	String value,
									Map<String, Object> aladdinSetting) {
		return getAoRoundedStockQuantityValue(value, aladdinSetting);
	}

	public Object stock_quantity(String value) {
		return getAoRoundedStockQuantityValue(value, aladdinSetting);
	}

	/**
	 *
	 * 入数フォーマット
	 *
	 * @param value
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	public Object unit_quantity(String value,
								Map<String, Object> aladdinSetting) {
		return getAoRoundedUnitQuantityValue(value, aladdinSetting);
	}

	public Object unit_quantity(String value) {
		return getAoRoundedUnitQuantityValue(value, aladdinSetting);
	}

	/**
	 *
	 * 売上数量フォーマット
	 *
	 * @param value
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	public Object sales_quantity(	String value,
									Map<String, Object> aladdinSetting) {
		return getAoRoundedSalesQuantityValue(value, aladdinSetting);
	}

	public Object sales_quantity(String value) {
		return getAoRoundedSalesQuantityValue(value, aladdinSetting);
	}

	/**
	 *
	 * 売上ケース数量フォーマット
	 *
	 * @param value
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	public Object sales_case_quantity(	String value,
										Map<String, Object> aladdinSetting) {
		return getAoRoundedSalesCaseQuantityValue(value, aladdinSetting);
	}

	public Object sales_case_quantity(String value) {
		return getAoRoundedSalesCaseQuantityValue(value, aladdinSetting);
	}

	/**
	 *
	 * 売上単価フォーマット
	 *
	 * @param value
	 * @param user
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	@SuppressWarnings("unchecked")
	protected Object getAoRoundedSalesUnitPriceValue(	String value,
														Map<String, Object> user,
														Map<String, Object> aladdinSetting) {
		String retValue = "0";
		String digitNum = "";
		String decimalPointNum = "";
		String roundingDiv = "";
		try {
			if (!MapUtils.isEmpty(aladdinSetting)) {
				digitNum = (String) ((Map<String, Object>) aladdinSetting
						.get("売上単価整数桁")).get(VALUE_FIELD);
				decimalPointNum = (String) ((Map<String, Object>) aladdinSetting
						.get("売上単価小数点桁")).get(VALUE_FIELD);
				roundingDiv = (String) ((MapUtils.isEmpty(user)) ? null
						: user.get("unit_price_fraction_div"));
			}
			if (!StringUtils.isEmpty(digitNum)
					&& !StringUtils.isEmpty(decimalPointNum)) {
				retValue = AoUtil.convAoRoundingSalesUnitPrice(value,
						AoUtil.DispPattern.PATTERN_NO_COMMA, digitNum,
						decimalPointNum, roundingDiv);
			}
			return retValue;
		} catch (NumberFormatException e) {
			return value;
		}
	}

	/**
	 *
	 * 売上金額フォーマット
	 *
	 * @param value
	 * @param user
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	@SuppressWarnings("unchecked")
	protected Object getAoRoundedSalesPriceValue(	String value,
													Map<String, Object> user,
													Map<String, Object> aladdinSetting) {
		String retValue = "0";
		String digitNum = "";
		String decimalPointNum = "";
		String roundingDiv = "";
		try {
			if (!MapUtils.isEmpty(aladdinSetting)) {
				digitNum = (String) ((Map<String, Object>) aladdinSetting
						.get("売上金額整数桁")).get(VALUE_FIELD);
				roundingDiv = (String) ((MapUtils.isEmpty(user)) ? null
						: user.get("price_fraction_div"));
			}
			if (!StringUtils.isEmpty(digitNum)) {
				retValue = AoUtil.convAoRoundingSalesPrice(value, "1",
						AoUtil.DispPattern.PATTERN_NO_COMMA, digitNum,
						roundingDiv);
			}
			return retValue;
		} catch (NumberFormatException e) {
			return value;
		}
	}

	/**
	 *
	 * 在庫数フォーマット
	 *
	 * @param value
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	@SuppressWarnings("unchecked")
	protected Object getAoRoundedStockQuantityValue(String value,
													Map<String, Object> aladdinSetting) {
		String retValue = "0";
		String digitNum = "";
		String decimalPointNum = "";
		String roundingDiv = "";
		try {
			if (!MapUtils.isEmpty(aladdinSetting)) {
				digitNum = (String) ((Map<String, Object>) aladdinSetting
						.get("在庫数量整数桁")).get(VALUE_FIELD);
				decimalPointNum = (String) ((Map<String, Object>) aladdinSetting
						.get("在庫数量小数点桁")).get(VALUE_FIELD);
				roundingDiv = (String) ((Map<String, Object>) aladdinSetting
						.get("在庫数量端数処理区分")).get(VALUE_FIELD);
			}
			if (!StringUtils.isEmpty(digitNum)
					&& !StringUtils.isEmpty(decimalPointNum)) {
				retValue = AoUtil.convAoRoundingStockQuantity(value,
						AoUtil.DispPattern.PATTERN_NO_COMMA, digitNum,
						decimalPointNum, roundingDiv);
			}
			return retValue;
		} catch (NumberFormatException e) {
			return value;
		}
	}

	/**
	 *
	 * 入数フォーマット
	 *
	 * @param value
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	@SuppressWarnings("unchecked")
	protected Object getAoRoundedUnitQuantityValue(	String value,
													Map<String, Object> aladdinSetting) {
		String retValue = "0";
		String digitNum = "";
		String decimalPointNum = "";
		String roundingDiv = "";
		try {
			if (!MapUtils.isEmpty(aladdinSetting)) {
				digitNum = (String) ((Map<String, Object>) aladdinSetting
						.get("入数整数桁")).get(VALUE_FIELD);
				decimalPointNum = (String) ((Map<String, Object>) aladdinSetting
						.get("入数小数点桁")).get(VALUE_FIELD);
				roundingDiv = "0";
			}
			if (!StringUtils.isEmpty(digitNum)
					&& !StringUtils.isEmpty(decimalPointNum)
					&& !StringUtils.isEmpty(roundingDiv)) {
				retValue = AoUtil.convAoRoundingUnitQuantity(value,
						AoUtil.DispPattern.PATTERN_NO_COMMA, digitNum,
						decimalPointNum, roundingDiv);
			}
			return retValue;
		} catch (NumberFormatException e) {
			return value;
		}
	}

	/**
	 *
	 * 売上数量フォーマット
	 *
	 * @param value
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	@SuppressWarnings("unchecked")
	protected Object getAoRoundedSalesQuantityValue(String value,
													Map<String, Object> aladdinSetting) {
		String retValue = "0";
		String digitNum = "";
		String decimalPointNum = "";
		String roundingDiv = "";
		try {
			if (!MapUtils.isEmpty(aladdinSetting)) {
				digitNum = (String) ((Map<String, Object>) aladdinSetting
						.get("売上数量整数桁")).get(VALUE_FIELD);
				decimalPointNum = (String) ((Map<String, Object>) aladdinSetting
						.get("売上数量小数点桁")).get(VALUE_FIELD);
				roundingDiv = (String) ((Map<String, Object>) aladdinSetting
						.get("売上数量端数処理区分")).get(VALUE_FIELD);
			}
			if (!StringUtils.isEmpty(digitNum)
					&& !StringUtils.isEmpty(decimalPointNum)
					&& !StringUtils.isEmpty(roundingDiv)) {
				retValue = AoUtil.convAoRoundingSalesQuantity(value,
						AoUtil.DispPattern.PATTERN_NO_COMMA, digitNum,
						decimalPointNum, roundingDiv);
			}
			return retValue;
		} catch (NumberFormatException e) {
			return value;
		}
	}

	/**
	 *
	 * 売上ケース数量フォーマット
	 *
	 * @param value
	 * @param aladdinSetting
	 * @return フォーマットされた値
	 */
	@SuppressWarnings("unchecked")
	protected Object getAoRoundedSalesCaseQuantityValue(String value,
														Map<String, Object> aladdinSetting) {
		String retValue = "0";
		String digitNum = "";
		String decimalPointNum = "";
		String roundingDiv = "";
		try {
			if (!MapUtils.isEmpty(aladdinSetting)) {
				digitNum = (String) ((Map<String, Object>) aladdinSetting
						.get("ケース数整数桁")).get(VALUE_FIELD);
				decimalPointNum = (String) ((Map<String, Object>) aladdinSetting
						.get("ケース数小数点桁")).get(VALUE_FIELD);
				roundingDiv = (String) ((Map<String, Object>) aladdinSetting
						.get("ケース数端数処理区分")).get(VALUE_FIELD);
			}
			if (!StringUtils.isEmpty(digitNum)
					&& !StringUtils.isEmpty(decimalPointNum)
					&& !StringUtils.isEmpty(roundingDiv)) {
				retValue = AoUtil.convAoRoundingCaseQuantity(value,
						AoUtil.DispPattern.PATTERN_NO_COMMA, digitNum,
						decimalPointNum, roundingDiv);
			}
			return retValue;
		} catch (NumberFormatException e) {
			return value;
		}
	}

}
