package jp.ill.photon.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonFrameworkException;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.exception.PhotonPageNotFoundException;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlTextSelectModule;

public interface PhotonService {

	public void execute() throws PhotonFrameworkException,
			PhotonModuleException, PhotonPageNotFoundException;

	/**
	 * テナントリストを取得
	 * 
	 * @return
	 */
	default List<Map<String, Object>> getTenantList() {
		String sql = "select * from tenant order by tenant_id asc";
		Map<String, Object> params = new HashMap<>();
		return executeQuery(sql, params);
	}

	/**
	 * クエリを実行
	 * 
	 * @param sql
	 * @param params
	 * @return
	 */
	default List<Map<String, Object>> executeQuery(	String sql,
													Map<String, Object> params) {
		SearchForm searchForm = SearchForm.valueOf(params);
		SqlTextSelectModule module = new SqlTextSelectModule();
		module.setSearchForm(searchForm);
		module.setSqlText(sql);

		ActionDto dto = new ActionDto();
		ModuleContext context = new ModuleContext(dto);
		ModuleResult result = null;
		try {
			result = module.execute(context);
		} catch (PhotonModuleException e) {
			e.printStackTrace();
		}

		List<Map<String, Object>> resultList = (List) result.getReturnData()
				.get("list");

		return resultList;
	}

}
