package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

public class StringComparatorValidationModule extends AbstractValidationModule {

	@SuppressWarnings("unchecked")
	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		// 入力値Ａ
		Map<Object, Object> transfer = (Map<Object, Object>) ruleParams.getOrDefault("master_string", "");
		String masterString = String.valueOf(
				ParamUtil.getParamValueByType(String.valueOf(transfer.get("type")), transfer.get("val"), context.getDto()));

		// 入力値Ｂ
		transfer = (Map<Object, Object>) ruleParams.getOrDefault("re_enter_string", "");
		String reEnterString = String.valueOf(
				ParamUtil.getParamValueByType(String.valueOf(transfer.get("type")), transfer.get("val"), context.getDto()));

		// 入力値Ａと入力値Ｂが同値の場合はＯＫとする
		if (masterString != null) {
			if (masterString.equals(reEnterString)) {
				return true;
			}
		}

		return false;
	}
}
