package jp.ill.photon.module.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.query.SqlSelectQuery;

import jp.ill.photon.doma.SqlSelectQueryFactory;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.CryptUtil;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;

@SuppressWarnings("unchecked")
public class SqlFileSelectValidationModule extends AbstractValidationModule {

	ActionDto dto;

	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		dto = context.getDto();

		Map<String, Object> searchForm = (Map<String, Object>) ParamUtil
				.getParamObjectValueByType(ruleParams.get("search_form"), dto);
		String sqlFileDirPath = (String) ParamUtil.getParamStrValueByType(
				ruleParams.get("sql_file_dir_path"), dto);
		String sqlFilePath = (String) ParamUtil
				.getParamStrValueByType(ruleParams.get("sql_file_path"), dto);

		Map<String, Object> successMap = generateParamMap(
				(Map<String, Object>) ParamUtil.getParamObjectValueByType(
						ruleParams.get("condition_map"), dto));

		// SQLを実行するための情報がないものはエラー
		if (StringUtils.isEmpty(sqlFileDirPath)
				|| StringUtils.isEmpty(sqlFilePath)
				|| MapUtils.isEmpty(successMap)) {
			return false;
		}

		searchForm.put("paramValue", new HashMap<String, Object>() {
			{
				put("type", "static");
				put("val", paramValue);
			}
		});
		String paramMapStr = (!MapUtils.isEmpty(getParamMap()))
				? JsonUtil.mapToJson(getParamMap()) : "";
		searchForm.put("paramMapStr", new HashMap<String, Object>() {
			{
				put("type", "static");
				put("val", paramMapStr);
			}
		});

		String cacheKey = null;
		if (this.isCacheable()) {
			Map<String, Object> searchFormVal = (Map<String, Object>) searchForm
					.getOrDefault("val", new HashMap<>());
			Map<String, Object> cacheVal = new HashMap<>();
			for (Map.Entry<String, Object> entry : searchFormVal.entrySet()) {
				if (!(entry.getKey().equals("paramMapStr")
						|| entry.getKey().equals("requests"))) {
					cacheVal.put(entry.getKey(), entry.getValue());
				}
			}
			Map<String, Object> cacheMap = this.getResultCacheMap();
			Map<String, Object> keyMap = new HashMap<>();
			keyMap.put("sql_file_dir_path", sqlFileDirPath);
			keyMap.put("sql_file_path", sqlFilePath);
			keyMap.put("search_form", cacheVal);
			keyMap.put("condition_map", successMap);
			keyMap.put("param_value", paramValue);
			cacheKey = CryptUtil.createMd5Utf(JsonUtil.mapToJson(keyMap));

			Object r = cacheMap.getOrDefault(cacheKey, null);
			if (r != null) {
				return (Boolean) r;
			}
		}

		boolean validationResult = true;
		try {

			SqlSelectQuery selectQuery = SqlSelectQueryFactory.newInstance()
					.createSelectQueryFromFile(searchForm, dto, sqlFileDirPath,
							sqlFilePath);

			selectQuery.prepare();

			// 検索処理を実行
			// 結果は必ず1行で返却すること
			// 複数取得できている場合は1行目のみを評価対象とする
			// OKとなる条件を格納したマップをみて判定する

			SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
					selectQuery,
					new MapResultListHandler(MapKeyNamingType.NONE));
			List<Map<String, Object>> resultList = command.execute();

			Map<String, Object> result = (resultList != null
					&& resultList.size() >= 1) ? resultList.get(0)
							: new HashMap<String, Object>();
			setValidateResults(result);
			// 結果のなかにOKとなる条件を格納したマップのキーがなかったり、
			// 取得された値が違っていたりしたらエラー
			for (Map.Entry<String, Object> e : successMap.entrySet()) {
				if (!result.containsKey(e.getKey())) {
					validationResult = false;
				}
				if (!StringUtils.equals((String) result.get(e.getKey()),
						(String) e.getValue())) {
					validationResult = false;
				}
			}

		} catch (PhotonModuleException e) {

			validationResult = false;

		}

		if (this.isCacheable()) {
			this.getResultCacheMap().put(cacheKey, validationResult);
		}

		return validationResult;
	}

	private Map<String, Object> generateParamMap(Map<String, Object> src) {

		Map<String, Object> ret = new HashMap<String, Object>();
		if (!MapUtils.isEmpty(src)) {

			for (Map.Entry<String, Object> e : src.entrySet()) {
				ret.put(e.getKey(),
						ParamUtil.getParamObjectValueByType(e.getValue(), dto));
			}

		}

		return ret;

	}

	@Override
	public boolean validateObjectValue(	String paramName,
										Map<String, Object> ruleParams,
										Object paramValue,
										ModuleContext context) {

		String[] values = (String[]) paramValue;
		String strVal = "";

		if (values != null && values.length > 0) {
			strVal = String.join(",", values);
		}

		return validate(paramName, ruleParams, strVal, context);
	}

}
