package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

/**
 * 正規表現マッチモジュール
 * 
 * @author h_tanaka
 *
 */
public class RegexFormatValidationModule
		extends AbstractFormatValidationModule {

	@Override
	protected String getPatternStr() {
		return null;
	}

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		Map<String, Object> formatTransfer = (Map<String, Object>) ruleParams
				.getOrDefault("format", null);
		String format = "";
		if (formatTransfer != null) {
			format = String.valueOf(ParamUtil.getParamValueByType(
					String.valueOf(formatTransfer.get("type")),
					formatTransfer.get("val"), context.getDto()));
		}

		if (format != "") {
			return paramValue.matches(format);
		}

		return true;
	}
}
