package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.ParamUtil;

@ModuleVersion("1.0.0")
public class PassCharaValidationType6Module extends AbstractValidationModule {

	@ModuleParam(required=true)
	private String pwCheckKind;

	@ModuleParam(required=true)
	private String checkObject;

	public String getPwCheckKind() {
		return pwCheckKind;
	}

	public void setPwCheckKind(String pwCheckKind) {
		this.pwCheckKind = pwCheckKind;
	}

	public String getCheckObject() {
		return checkObject;
	}

	public void setCheckObject(String checkObject) {
		this.checkObject = checkObject;
	}

	/** パスワードタイプ */
	public static class PwType {
		/** 半角英字のみ */
		public static final String TYPE_1 = "0";
		/** 半角英数字のみ */
		public static final String TYPE_2 = "1";
		/** 半角英字、数字いずれも含む */
		public static final String TYPE_3 = "2";
		/** 半角英小文字、半角英大文字、数字いずれも含む */
		public static final String TYPE_4 = "3";
		/** 半角英数記号のみ */
		public static final String TYPE_5 = "4";
		/** 半角英数記号のみでいずれも含む */
		public static final String TYPE_6 = "5";
		/** 半角英数記号のみで英小文字、大文字、数字、記号いずれも含む */
		public static final String TYPE_7 = "6";
	}

	@SuppressWarnings("unchecked")
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		// INパラメータが無い場合、ruleParamsより取得
		if (checkObject == null) {
			Map<Object, Object> transfer = (Map<Object, Object>) ruleParams.getOrDefault("check_object", "");
			checkObject = String.valueOf(
					ParamUtil.getParamValueByType(String.valueOf(transfer.get("type")), transfer.get("val"), context.getDto()));
		}
		if (pwCheckKind == null) {
			Map<Object, Object> transfer = (Map<Object, Object>) ruleParams.getOrDefault("pw_check_kind", "");
			pwCheckKind = String.valueOf(
					ParamUtil.getParamValueByType(String.valueOf(transfer.get("type")), transfer.get("val"), context.getDto()));
		}

		// パスワード ： 入力文字チェック
		// 半角英数記号のみでいずれも含む
		return CheckUtil.isAlphaNumSignCheckAll(getCheckObject());
	}

}
