package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.CheckUtil;

@ModuleVersion("1.0.0")
public class PassCharaValidationModule extends AbstractValidationModule {

	@ModuleParam(required=true)
	private String pwCheckKind;

	@ModuleParam(required=true)
	private String checkObject;

	public String getPwCheckKind() {
		return pwCheckKind;
	}

	public void setPwCheckKind(String pwCheckKind) {
		this.pwCheckKind = pwCheckKind;
	}

	public String getCheckObject() {
		return checkObject;
	}

	public void setCheckObject(String checkObject) {
		this.checkObject = checkObject;
	}

	/** パスワードタイプ */
	public static class PwType {
		/** 半角英字のみ */
		private static final String HANKAKU_EIJI = "0";
		/** 半角英数字のみ */
		private static final String HANKAKU_EISUJI = "1";
		/** 半角英字、数字いずれも含む */
		private static final String HANKAKU_EISUJI_MUST = "2";
		/** 半角英小文字、半角英大文字、数字いずれも含む */
		private static final String HANKAKU_EISU_KOMOJI_OMOJI_MUST = "3";
		/** 半角英数記号のみ */
		private static final String HANKAKU_EISU_KIGOU = "4";
		/** 半角英数記号のみでいずれも含む */
		private static final String HANKAKU_EISU_KIGOU_MUST = "5";
		/** 半角英数記号のみで英小文字、大文字、数字、記号いずれも含む */
		private static final String HANKAKU_EISU_KOMOJI_OMOJI_KIGOU_MUST = "6";
	}

	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		// 返り値を定義
		boolean result = true;

		// パスワード ： 入力文字チェック
		// 半角英字のみ
		if (PwType.HANKAKU_EIJI.equals(getPwCheckKind())) {
			if (!CheckUtil.isAlphaCheck(getCheckObject())) {
				result = false;
			}
		}
		// 半角英数字のみ
		else if (PwType.HANKAKU_EISUJI.equals(getPwCheckKind())) {
			if (!CheckUtil.isAlphaNumCheck(getCheckObject())) {
				result = false;
			}
		}
		// 半角英字、数字いずれも含む
		else if (PwType.HANKAKU_EISUJI_MUST.equals(getPwCheckKind())) {
			if (!CheckUtil.isAlphaNumCheckAll(getCheckObject())) {
				result = false;
			}
		}
		// 半角英小文字、半角英大文字、数字いずれも含む
		else if (PwType.HANKAKU_EISU_KOMOJI_OMOJI_MUST.equals(getPwCheckKind())) {
			if (!CheckUtil.isAlphaSizeNumCheckAll(getCheckObject())) {
				result = false;
			}
		}
		// 半角英数記号のみ
		else if (PwType.HANKAKU_EISU_KIGOU.equals(getPwCheckKind())) {
			if (!CheckUtil.isAlphaNumSignCheckWithoutSpace(getCheckObject())) {
				result = false;
			}
		}
		// 半角英数記号のみでいずれも含む
		else if (PwType.HANKAKU_EISU_KIGOU_MUST.equals(getPwCheckKind())) {
			if (!CheckUtil.isAlphaNumSignCheckAll(getCheckObject())) {
				result = false;
			}
		}
		// 半角英数記号のみで英小文字、大文字、数字、記号いずれも含む
		else if (PwType.HANKAKU_EISU_KOMOJI_OMOJI_KIGOU_MUST.equals(getPwCheckKind())) {
			if (!CheckUtil.isAlphaSizeNumSignCheckAll(getCheckObject())) {
				result = false;
			}
		}

		return result;
	}

}
