package jp.ill.photon.module.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleFactory;
import jp.ill.photon.module.ModuleRepository;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.module.validation.FormValidator.ErrorMessageType;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.MapUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

@ModuleVersion("1.0.0")
@Deprecated
public class ParamValidateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@ModuleParam(required = false)
	private Map<String, Object> paramNames;

	@ModuleParam(required = false)
	private Map<String, Object> after;

	@ModuleParam(required = false)
	private Map<String, Object> carryOverErrors;

	@ModuleParam(required = false)
	private Map<String, Object> extraParamMap;

	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

	public Map<String, Object> getParamNames() {
		return paramNames;
	}

	public void setParamNames(Map<String, Object> paramNames) {
		this.paramNames = paramNames;
	}

	public Map<String, Object> getAfter() {
		return after;
	}

	public void setAfter(Map<String, Object> after) {
		this.after = after;
	}

	public Map<String, Object> getCarryOverErrors() {
		return carryOverErrors;
	}

	public void setCarryOverErrors(Map<String, Object> carryOverErrors) {
		this.carryOverErrors = carryOverErrors;
	}

	public Map<String, Object> getExtraParamMap() {
		return extraParamMap;
	}

	public void setExtraParamMap(Map<String, Object> extraParamMap) {
		this.extraParamMap = extraParamMap;
	}

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(SingleValidator.class);

	// モジュール内で使用する変数
	private ActionDto dto;

	private String returnPrefix;
	private Map<String, String> paramValidations;
	private Map<String, Object> paramValues;
	private Map<String, Object> errorMessageListMap;

	@SuppressWarnings("unchecked")
	@Override
	public ModuleResult execute(ModuleContext context) {

		dto = context.getDto();
		errorMessageListMap = new LinkedHashMap<>();

		Map<String, Object> actionModule = context.getActionModule();
		returnPrefix = (String) actionModule.get("return_prefix");

		// パラメータを整理
		getMapFromParamJson();

		// バリデート処理を実行
		// バリデーションを行い、errorMessageListMapにセットする
		validateParams();

		ModuleResult result = new ModuleResult();
		result.setMessages(errorMessageListMap);
		if (errorMessageListMap.isEmpty()) {
			result.setResultCode("validate_ok");
			result.setResultType(ModuleResult.ResultTypes.CONTINUE);
			result.getReturnData().put("validate_result", "validate_ok");
		} else {
			result.setResultCode("validate_ng");
			result.setResultType(ModuleResult.ResultTypes.ERROR);
			result.getReturnData().put("validate_result", "validate_ng");

			//■□■□■□■□■□■□■□■□■□■□■□■□
			//■□  ページエラーメッセージ追加処理        ■□
			//TODO:L.Satta - ParamValidateModuleのクラスは@Deprecatedである為、使用禁止ですが既存でも使用されている・・

			// エラーが存在したらページエラーメッセージを追加
			ActionDtoMessage pageError = new ActionDtoMessage();
			pageError.setMessageId("commonValidateError");
			pageError.setParams(new HashMap<String, Object>());
			addErrMsgListMap(ErrorMessageType.ERROR_PAGE, pageError, 0);
			//■□  ページエラーメッセージ追加処理        ■□
			//■□■□■□■□■□■□■□■□■□■□■□■□
		}

		// モジュールのパラメータ"after"に値がセットされていたとき
		if (after != null) {
			logger.info("　パラメータ[after]が設定されていたので、後処理を登録します。");
			Map<String, Object> mp = (Map<String, Object>) after
					.get(result.getResultCode());
			if (mp != null) {
				result.getReturnData().put("after_params", mp.get("params"));
				result.setNextPath((String) mp.get("next_path"));
				result.setResultType((String) mp.get("result_type"));
			}
		}

		return result;
	}

	/**
	 * パラメータマップのバリデーションを行い、パラメータ名毎のエラーメッセージリストのマップを返す。
	 *
	 * @param tenantId テナントID
	 * @param paramMap パラメータと値のマップオブジェクト
	 * @param paramValidationSetMap パラメータ名をキー、バリデーションセットIDを値として持つマップ
	 * @return
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected void validateParams() {

		// 使用するバリデーションセットIDのリストを作成する
		List<String> validationSetIdList = paramValidations.values().stream()
				.distinct().collect(Collectors.toList());

		ModuleRepository moduleRepository = ModuleRepository.newInstance();

		// バリデーションセットIDをキーとしてバリデーションセット設定を値として持つマップを取得する
		Map<String, Object> validationSetSettings = moduleRepository
				.getValidationSetSettings(dto.getTenantId(),
						validationSetIdList);

		// 使用するバリデーションモジュールのモジュールIDのリストをバリデーションセット設定から抽出する
		List<String> moduleIdList = getModuleIdListFromValidationSetSettings(
				validationSetSettings);

		// バリデーションモジュール設定を取得
		Map<String, Object> moduleSettings = moduleRepository
				.getModuleSettings(moduleIdList);

		// 各バリデーションモジュールクラスをインスタンス化してモジュールIDをキーとするマップにまとめる
		Map<String, AbstractValidationModule> moduleMap = moduleSettings
				.entrySet().stream()
				.collect(Collectors.toMap(s -> s.getKey(),
						s -> (AbstractValidationModule) ModuleFactory
								.get((String) ((Map) s.getValue())
										.get("module_class"))));

		// Map<String, List<String>> errorMessageListMap = new
		// LinkedHashMap<>();

		// List<String> errorMessageList = null;
		for (Map.Entry<String, Object> entry : paramValues.entrySet()) {

			validateParam(entry.getKey(), entry.getValue(),
					(Map) validationSetSettings
							.get(paramValidations.get(entry.getKey())),
					moduleMap);

			// if (errorMessageList.size() > 0) {
			// errorMessageListMap.put(entry.getKey(), errorMessageList);
			// }
		}

		// return errorMessageListMap;

	}

	/**
	 * 1パラメータのバリデーションを行い、エラーメッセージのリストを返す
	 *
	 * @param paramName パラメータ名、フィールドコードかカラムコード
	 * @param paramValue パラメータ値
	 * @param validationRules
	 * @param moduleMap バリデーションモジュールオブジェクトのマップ
	 * @return
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected void validateParam(	String paramName,
									Object paramValue,
									Map<String, Object> validationSetSetting,
									Map<String, AbstractValidationModule> moduleMap) {

		List<Map<String, Object>> validationList = (List) ((Map) validationSetSetting
				.get("validations")).get("list");

		AbstractValidationModule module = null;
		ModuleResult result = null;
		for (Map<String, Object> validation : validationList) {

			logger.info("　バリデーションモジュールID：" + validation.get("module_id"));

			module = moduleMap.get(validation.get("module_id"));

			String name = paramName;
			if (paramNames != null && paramNames.get(paramName) != null) {
				name = ParamUtil
						.getParamStrValueByType(paramNames.get(paramName), dto);
			}

			module.setParamName(name);

			if (paramValue == null || (paramValue != null
					&& ((paramValue instanceof String)))) {
				module.setParamValue((String) paramValue);
				module.setParamRawValue(null);
			} else {
				module.setParamRawValue(paramValue);
				module.setParamValue(null);
			}
			boolean isBlankValue = CheckUtil.isBlankObject(paramValue);

			Map<String, Object> params = ((Map) validation.get("params"));
			if (this.extraParamMap != null) {
				params = MapUtil.mergeMapHierarchically(params, this.extraParamMap);
			}
			module.setRuleParams(params);

			// "skip_blank"は、未設定のときはfalseとして扱う
			Boolean dontCheckIfBlank = (Boolean) validation.get("skip_blank");
			if (dontCheckIfBlank == null) {
				dontCheckIfBlank = false;
			}

			// 実行可能条件を満たさない場合はバリデーションを実施しない
			Map<String, Object> ruleParams = params;
			if (ruleParams != null && !module
					.isExecutable(new ModuleContext(dto), ruleParams)) {
				logger.info("　　実行条件を満たしません。実行はスキップされました。");
				continue;
			}

			// "skip_blank"がtrueで、検査対象値が空の場合は、
			// そのバリデーションを行わない
			if (!dontCheckIfBlank || !isBlankValue) {

				ModuleContext context = new ModuleContext(dto);
				result = module.execute(context);

				if (result.getResultType()
						.equals(ModuleResult.ResultTypes.ERROR)) {

					logger.info("　　バリデーションエラー");

					Map<String, Object> validationResults = (Map<String, Object>) result
							.getReturnData()
							.getOrDefault("validate_results", new HashMap<>());

					// エラーメッセージセット
					generateMessageObj(paramName, name,
							validation.get("message"), validationResults);

					boolean isLast = (Boolean) validation.get("is_last");
					if (isLast) {
						break;
					}
				}

			} else {

				logger.info("　　実行はスキップされました。");
				continue;
			}
		}

	}

	/**
	 * バリデーションセットのリストに含まれるモジュールIDのリストを取得する
	 *
	 * @param validationSetSettings
	 * @return
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected List<String> getModuleIdListFromValidationSetSettings(Map<String, Object> validationSetSettings) {
		List<String> moduleIdListList = new ArrayList<>();
		Map<String, Object> validations = null;
		List<Object> validationList = null;
		List<String> moduleIdList = null;
		for (Map.Entry<String, Object> setting : validationSetSettings
				.entrySet()) {
			validations = (Map) ((Map) setting.getValue()).get("validations");
			validationList = (List) validations.get("list");
			moduleIdList = validationList.stream()
					.map(s -> (String) ((Map) s).get("module_id"))
					.collect(Collectors.toList());
			moduleIdListList.addAll(moduleIdList);
		}

		return moduleIdListList.stream().distinct()
				.collect(Collectors.toList());
	}

	/***
	 *
	 * パラメータから、カラムコードと値のペアを作成
	 *
	 * @param dto
	 *
	 * @return
	 *
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected void getMapFromParamJson() {

		// パラメータを整理
		paramValues = new LinkedHashMap<String, Object>();
		paramValidations = new HashMap<>();

		if (paramJson != null) {

			Map<String, String> paramInfo = null;

			for (Map.Entry<String, Object> param : paramJson.entrySet()) {

				paramInfo = (Map) param.getValue();

				paramValues.put(param.getKey(), ParamUtil
						.getParamObjectValueByType(param.getValue(), dto));

				paramValidations.put(param.getKey(),
						paramInfo.get("validation_set"));

			}

		}

	}

	/***
	 *
	 * メッセージオブジェクトを生成する<br />
	 *
	 * @param formFieldCd
	 * @param formFieldName
	 * @param messageSetting
	 * @param dto
	 *
	 * @return
	 *
	 */
	@SuppressWarnings("unchecked")
	protected void generateMessageObj(	String formFieldCd,
										String formFieldName,
										Object messageSetting,
										Map<String, Object> validationResults) {

		ActionDtoMessage ret = new ActionDtoMessage();

		ret.setReturnPrefix(returnPrefix);
		ret.setFormFieldCd(formFieldCd);
		String errorMessageType = ErrorMessageType.ERROR_FIELD;

		Map<String, Object> setting = (Map<String, Object>) messageSetting;
		if (!MapUtils.isEmpty(setting)) {

			// メッセージID取得
			ret.setMessageId(
					ParamUtil.getParamStrValueByType(setting.get("id"), dto));
			// メッセージパラメータ取得
			Map<String, Object> setParams = new HashMap<String, Object>();
			Map<String, Object> params = (Map<String, Object>) ParamUtil
					.getParamObjectValueByType(setting.get("param"), dto);

			if (!MapUtils.isEmpty(
					(Map<String, Object>) setting.get("message_type"))) {
				String val = ParamUtil.getParamStrValueByType(
						(Map<String, Object>) setting.get("message_type"), dto);
				if (!StringUtils.isEmpty(val)) {
					errorMessageType = val;
				}
			}

			if (params != null) {
				for (Map.Entry<String, Object> param : params.entrySet()) {

					String type = (String) ((Map<String, Object>) param
							.getValue()).get("type");

					String value = (String) ((Map<String, Object>) param
							.getValue()).get("val");

					Map<String, Object> setParamItem = new HashMap<>();
					String returnVal = null;
					switch (type) {
					case "name":
						setParamItem.put("type", "static");
						setParamItem.put("val", formFieldName);
						setParams.put(param.getKey(), setParamItem);
						break;
					case "form":
						returnVal = (String) paramValues.get(value);
						setParamItem.put("type", "static");
						setParamItem.put("val", returnVal);
						setParams.put(param.getKey(), setParamItem);
						break;
					case "result":
						returnVal = StringUtil.defaultString(
								validationResults.getOrDefault(value, ""), "");
						setParamItem.put("type", "static");
						setParamItem.put("val", returnVal);
						setParams.put(param.getKey(), setParamItem);
						break;
					default:
						setParams.put(param.getKey(), param.getValue());
					}

				}
			}
			ret.setParams(setParams);

		}

		// エラーメッセージセット
		addErrMsgListMap(errorMessageType, ret);

	}

	/***
	 *
	 * エラーメッセージを指定したタイプの配列にセット
	 *
	 * @param type
	 * @param obj
	 *
	 */
	@SuppressWarnings("unchecked")
	protected void addErrMsgListMap(String type, ActionDtoMessage obj) {

		if (StringUtils.isEmpty(type)) {
			return;
		}

		List<ActionDtoMessage> list = (List<ActionDtoMessage>) errorMessageListMap
				.get(type);
		if (list == null) {
			list = new ArrayList<ActionDtoMessage>();
		}

		list.add(obj);

		errorMessageListMap.put(type, list);

	}

	//■□■□■□■□■□■□■□■□■□■□■□■□
	//■□  ページエラーメッセージ追加処理        ■□
	//TODO:L.Satta - ParamValidateModuleのクラスは@Deprecatedである為、使用禁止ですが既存でも使用されている・・

	/***
	 *
	 * エラーメッセージを指定したタイプの配列にセット
	 *
	 * @param type
	 * @param obj
	 *
	 */
	@SuppressWarnings("unchecked")
	private void addErrMsgListMap(	String type,
									ActionDtoMessage obj,
									int index) {

		if (StringUtils.isEmpty(type)) {
			return;
		}

		List<ActionDtoMessage> list = (List<ActionDtoMessage>) errorMessageListMap
				.get(type);
		if (list == null) {
			list = new ArrayList<ActionDtoMessage>();
		}

		if (index >= 0) {
			list.add(index, obj);
		} else {
			list.add(obj);
		}

		errorMessageListMap.put(type, list);

	}
	//■□  ページエラーメッセージ追加処理        ■□
	//■□■□■□■□■□■□■□■□■□■□■□■□

}
