package jp.ill.photon.module.validation;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

public class NumRangeValidationModule extends AbstractValidationModule {

	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		BigDecimal val = null;

		// ootah 前ゼロは許容する
//		if (!CheckUtil.isValidInteger(paramValue)) {
//			return false;
//		}

		try {
			val = new BigDecimal(paramValue);
		} catch (Exception e) {
		}

		if (val == null) {
			return false;
		}

		String minStr = StringUtil.defaultString(
				ParamUtil.getParamStrValueByType(ruleParams.get("min"),
						context.getDto()),
				"");
		BigDecimal min = StringUtil.toBigDecimal(minStr.replaceAll(",", ""),
				null);

		String maxStr = StringUtil.defaultString(
				ParamUtil.getParamStrValueByType(ruleParams.get("max"),
						context.getDto()),
				"");
		BigDecimal max = StringUtil.toBigDecimal(maxStr.replaceAll(",", ""),
				null);

		String notIncludeMax = StringUtil.defaultString(
				ParamUtil.getParamStrValueByType(
						ruleParams.get("not_include_max"), context.getDto()),
				"");

		String notIncludeMin = StringUtil.defaultString(
				ParamUtil.getParamStrValueByType(
						ruleParams.get("not_include_min"), context.getDto()),
				"");

		if (min == null && max == null) {
			return false;
		}

		boolean isMinOk = true;
		boolean isMaxOk = true;

		if (min != null) {
			if (notIncludeMin.equals("1")) {
				isMinOk = (min.compareTo(val) < 0);
			} else {
				isMinOk = (min.compareTo(val) <= 0);
			}
		}

		if (max != null) {
			if (notIncludeMax.equals("1")) {
				isMaxOk = (val.compareTo(max) < 0);
			} else {
				isMaxOk = (val.compareTo(max) <= 0);
			}
		}

		return isMinOk && isMaxOk;

	}

}
