package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

/**
 * 入力数値と、パラメータで渡された数値の合計値が最大値以下かどうかをチェックする
 * 
 * @author h_tanaka
 *
 */
public class NumMaxSumValidationModule extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {
		// 入力値
		int inputNum = Integer.parseInt(paramValue);

		// 加算数値
		Map<Object, Object> transfer = (Map<Object, Object>) ruleParams
				.getOrDefault("other_num", "0");
		int otherNum = Integer.parseInt(String.valueOf(ParamUtil
				.getParamValueByType(String.valueOf(transfer.get("type")),
						transfer.get("val"), context.getDto())));

		// 最大値
		transfer = (Map<Object, Object>) ruleParams.getOrDefault("max_num",
				"0");
		int maxNum = Integer.parseInt(String.valueOf(ParamUtil
				.getParamValueByType(String.valueOf(transfer.get("type")),
						transfer.get("val"), context.getDto())));

		// 入力値Ａと入力値Ｂが同値の場合はＯＫとする
		if (inputNum + otherNum > maxNum) {
			return false;
		}

		return true;
	}

}
