package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.lang3.StringUtils;

/**
 * 数値の整数部と小数部の桁数をチェックする
 *
 * @author h_tanaka
 *
 */
public class NumDecimalFormatValidationModule extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		if (paramValue == null) {
			return false;
		}

		if (paramValue.length() == 0) {
			return true;
		}

		// 整数部桁数
		Map<Object, Object> transfer = (Map<Object, Object>) ruleParams
				.getOrDefault("integral_max_digits", "0");
		int integralMaxDigits = Integer.parseInt(String.valueOf(ParamUtil
				.getParamValueByType(String.valueOf(transfer.get("type")),
						transfer.get("val"), context.getDto())));

		// 小数部桁数
		transfer = (Map<Object, Object>) ruleParams
				.getOrDefault("decimal_max_digits", "0");
		int decimalMaxDigits = Integer.parseInt(String.valueOf(ParamUtil
				.getParamValueByType(String.valueOf(transfer.get("type")),
						transfer.get("val"), context.getDto())));

		// 整数部のチェック時、マイナス記号を除去してから行う
		String excludeMinusSign = ParamUtil.getParamStrValueByType(
				ruleParams.get("exclude_minus_sign"), context.getDto());

		String integralVal = "";
		int integralDigits = 0;
		int decimalDigits = 0;
		String[] numParts = paramValue.split("\\.");
		if (numParts.length >= 2) {
			// integralDigits = numParts[0].length();
			integralVal = numParts[0];
			decimalDigits = numParts[1].length();
		} else if (numParts.length == 1) {
			// integralDigits = numParts[0].length();
			integralVal = numParts[0];
		} else {
			// integralDigits = paramValue.length();
			integralVal = paramValue;
		}
		if (!StringUtils.isEmpty(excludeMinusSign)) {
			if (integralVal.startsWith("-")) {
				integralVal = integralVal.substring(1, integralVal.length());
			}
		}
		integralDigits = integralVal.length();

		if (integralDigits <= integralMaxDigits
				&& decimalDigits <= decimalMaxDigits) {
			return true;
		}

		return false;
	}

}
