package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

public class MaxLengthValidationModule extends AbstractValidationModule {

	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		int maxLength = 0;
		Object paramMaxLength = ruleParams.get("max_length");
		if (paramMaxLength != null) {
			if (paramMaxLength instanceof Map) {
				maxLength = Integer.parseInt(ParamUtil.getParamStrValueByType(
						(Map<String, Object>) paramMaxLength,
						context.getDto()));
			} else {
				maxLength = Integer.parseInt(String
						.valueOf(ruleParams.getOrDefault("max_length", "0")));
			}
		}

		boolean result = true;
		if (paramValue != null && maxLength > 0) {
			int length = countLength(paramValue);
			if (length > maxLength) {
				return false;
			}
		}

		return result;
	}

	/**
	 * 文字数制限チェック<br>
	 * nullは0文字の文字列として扱います。
	 *
	 * @param string チェックする文字列
	 * @return int 文字数
	 **/
	protected int countLength(String string) {
		if (string == null) {
			string = "";
		}

		return string.length();
	}

}
