package jp.ill.photon.module.validation;

import java.io.File;
import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class MaxFileSizeValidationModule extends AbstractValidationModule {

	/*サイズ単位*/
	protected static class SizeUnit {
		public static final String BYTE = "B";
		public static final String KILO_BYTE = "KB";
		public static final String MEGA_BYTE = "MB";
	}

	@SuppressWarnings("unchecked")
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		// ファイルサイズを取得
		Map<String, Object> paramMaxSize = (Map<String, Object>) ruleParams.get("max_size");
		String valueMaxSize = StringUtils.defaultString(ParamUtil.getParamStrValueByType(paramMaxSize, context.getDto()), "0");
		BigDecimal bdMaxSize = new BigDecimal(valueMaxSize);

		// ファイルサイズ単を取得
		Map<String, Object> paramSizeUnit = (Map<String, Object>) ruleParams.get("size_unit");
		String valueSizeUnit = StringUtils.defaultString(ParamUtil.getParamStrValueByType(paramSizeUnit, context.getDto()), SizeUnit.BYTE);

		// D&Dのファイルかを取得
		Map<String, Object> paramDragAndDrop = (Map<String, Object>) ruleParams.get("drag_and_drop");
		String valueDragAndDrop = StringUtils.defaultString(ParamUtil.getParamStrValueByType(paramDragAndDrop, context.getDto()), "true");
		boolean dragAndDrop = Boolean.parseBoolean(valueDragAndDrop);

		BigDecimal dbSize = null;
		// paramValueで引き渡されたパスからファイル生成
		if (dragAndDrop) {
			byte[] inByte = Base64.decodeBase64(paramValue);
			dbSize = new BigDecimal(inByte.length);
		} else {
			File f = new File(paramValue);
			dbSize = new BigDecimal(f.length());
		}

		boolean result = true;
		// 検査値の算出
		BigDecimal bdTestSize = bdMaxSize;
		BigDecimal bdSousand = new BigDecimal(1024);
		if (SizeUnit.KILO_BYTE.equals(valueSizeUnit)) {
			bdTestSize = bdTestSize.multiply(bdSousand);
		} else if (SizeUnit.MEGA_BYTE.equals(valueSizeUnit)) {
			bdTestSize = bdTestSize.multiply(bdSousand).multiply(bdSousand);
		}
		if (bdTestSize.compareTo(dbSize) < 0) {
			result = false;
		}

		return result;
	}

}
