package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

public class MaxByteLengthValidationModule extends AbstractValidationModule {

	// 文字数チェック用半角文字
	public static final String HALF_STRINGS = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~｡｢｣､･ｦｧｨｩｪｫｬｭｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝﾞﾟ";

	@SuppressWarnings("unchecked")
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		// "max_length"にそのまま数値、文字列を設定するとその桁数でチェックする
		// Mapが設定されていた場合は、"type"と"val"を参照した結果の値でチェックする
		int maxLength = 0;
		Object paramMaxLength = ruleParams.get("max_length");
		if (paramMaxLength != null) {
			if (paramMaxLength instanceof Map) {
				maxLength = Integer.parseInt(
								ParamUtil.getParamStrValueByType(
									(Map<String, Object>)paramMaxLength,
									context.getDto()
								)
							);
			} else {
				maxLength = Integer.parseInt(
						String.valueOf(ruleParams.getOrDefault("max_length", "0")));
			}
		}

		boolean result = true;
		if (paramValue != null && maxLength > 0) {
			int byteLength = countByteLength(paramValue);
			if (byteLength > maxLength) {
				return false;
			}
		}

		return result;
	}

	/**
	 * 文字数制限チェック<br>
	 * 半角を1全角を2としてチェックを行います。<br>
	 * nullは0文字の文字列として扱います。
	 *
	 * @param string チェックする文字列
	 * @param n チェックする文字数
	 * @return int 半角計算での桁数
	 **/
	protected int countByteLength(String string) {
		if (string == null) {
			string = "";
		}

		int count = 0;
		String s = null;
		for (int i = 0; i < string.length(); i++) {
			s = String.valueOf(string.charAt(i));
			// 半角文字かそれ以外かチェック
			if (HALF_STRINGS.indexOf(s) != -1) {
				// 半角文字
				count += 1;
			} else {
				// 全角文字
				count += 2;
			}
		}

		return count;
	}

}
