package jp.ill.photon.module.validation;

import java.util.List;
import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

/**
 * 入力値がパラメータのリストに含まれるかチェック
 * 
 * @author h_tanaka
 *
 */
public class InListValidationModule extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		List<Object> list = (List<Object>) ParamUtil.getParamObjectValueByType(
				ruleParams.get("list"), context.getDto());

		boolean result = false;
		String listVal = null;
		for (Object item : list) {
			listVal = StringUtil.defaultString(item, "");
			if (listVal.equals(paramValue)) {
				result = true;
				break;
			}
		}

		return result;
	}

}
