package jp.ill.photon.module.validation;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

/**
 * 指定ファイルパスの行数範囲をチェックするモジュール
 * 
 * @author h_tanaka
 *
 */
public class FileLineNumRangeValidationModule extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		String filePath = StringUtil.defaultString(paramValue, "");
		if (filePath == "") {
			return false;
		}

		String fileEncoding = StringUtil.defaultString(
				getActionParams().getOrDefault("file_encoding", "UTF-8"),
				"UTF-8");

		Path path = Paths.get(filePath);

		int totalLineCount = 0;
		try {
			totalLineCount = (int) Files
					.lines(path, Charset.forName(fileEncoding)).count();
		} catch (Exception e1) {
		}

		String minStr = StringUtil.defaultString(
				ParamUtil.getParamStrValueByType(ruleParams.get("min"),
						context.getDto()),
				"");
		int min = StringUtil.toInteger(minStr.replaceAll(",", ""),
				Integer.MIN_VALUE);

		String maxStr = StringUtil.defaultString(
				ParamUtil.getParamStrValueByType(ruleParams.get("max"),
						context.getDto()),
				"");
		int max = StringUtil.toInteger(maxStr.replaceAll(",", ""),
				Integer.MAX_VALUE);

		return (min <= totalLineCount && totalLineCount <= max);
	}

}
