package jp.ill.photon.module.validation;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.StringUtil;

/**
 * 指定ファイルパスの存在をチェックするモジュール
 * 
 * @author h_tanaka
 *
 */
public class FileExistenceValidationModule extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {
		String filePath = StringUtil.defaultString(paramValue, "");
		if (filePath == "") {
			return false;
		}

		Path path = Paths.get(filePath);
		return path.toFile().exists();
	}

}
