package jp.ill.photon.module.validation;

import java.util.List;
import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.collections.CollectionUtils;

public class ExtensionValidationModule extends AbstractValidationModule {

	@SuppressWarnings("unchecked")
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		List<String> list = (List<String>)ParamUtil.getParamObjectValueByType(ruleParams.get("list"), context.getDto());

		// listで渡された拡張子リストの中の拡張子を持っていればOK
		// 持っていなければNG
		boolean ret = false;
		if (!CollectionUtils.isEmpty(list)) {
			for (String extension : list) {
				if (paramValue.toLowerCase().endsWith(extension)){
					ret = true;
					break;
				}
			}
		}

		return ret;

	}

}
