package jp.ill.photon.module.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.CryptUtil;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

/**
 * 指定テーブル、指定カラムに入力値を持つデータが存在するかチェックする。 存在しなければエラー。
 *
 */
public class ExistValidationModule extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		// パラメータ：テーブルコード
		Map<Object, Object> transfer = (Map<Object, Object>) ruleParams
				.getOrDefault("table_cd", "");
		String tableCd = StringUtil.defaultString(ParamUtil.getParamValueByType(
				StringUtil.defaultString(transfer.get("type"), ""),
				transfer.get("val"), context.getDto()), "");

		// パラメータ：カラムコード
		transfer = (Map<Object, Object>) ruleParams.getOrDefault("col_cd", "");
		String colCd = StringUtil.defaultString(ParamUtil.getParamValueByType(
				StringUtil.defaultString(transfer.get("type"), ""),
				transfer.get("val"), context.getDto()), "");

		String cacheKey = null;
		if (this.isCacheable()) {
			Map<String, Object> cacheMap = this.getResultCacheMap();
			Map<String, Object> keyMap = new HashMap<>();
			keyMap.put("table_cd", tableCd);
			keyMap.put("col_cd", colCd);
			keyMap.put("param_value", paramValue);
			cacheKey = CryptUtil.createMd5Utf(JsonUtil.mapToJson(keyMap));

			Object r = cacheMap.getOrDefault(cacheKey, null);
			if (r != null) {
				return (Boolean) r;
			}
		}

		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> existingList = dao.getExistingList(
				context.getDto().getTenantId(), tableCd, colCd, paramValue);

		boolean validationResult = true;
		if (existingList == null || existingList.isEmpty()) {
			validationResult = false;
		} else {
			validationResult = true;
		}

		if (this.isCacheable()) {
			this.getResultCacheMap().put(cacheKey, validationResult);
		}

		return validationResult;
	}

}
