package jp.ill.photon.module.validation;

import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

public class DuplicateValidationModule extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		// パラメータ：テーブルコード
		Map<Object, Object> transfer = (Map<Object, Object>) ruleParams
				.getOrDefault("table_cd", "");
		String tableCd = String.valueOf(ParamUtil.getParamValueByType(
				String.valueOf(transfer.get("type")), transfer.get("val"),
				context.getDto()));

		// パラメータ：カラムコード
		transfer = (Map<Object, Object>) ruleParams.getOrDefault("col_cd", "");
		String colCd = String.valueOf(ParamUtil.getParamValueByType(
				String.valueOf(transfer.get("type")), transfer.get("val"),
				context.getDto()));

		// パラメータ：除外対象用カラムコード
		transfer = (Map<Object, Object>) ruleParams.getOrDefault("ex_col_cd",
				"");
		String exColCd = String.valueOf(ParamUtil.getParamValueByType(
				String.valueOf(transfer.get("type")), transfer.get("val"),
				context.getDto()));

		// パラメータ：除外対象用カラムコード
		transfer = (Map<Object, Object>) ruleParams
				.getOrDefault("ex_col_field_key", "");
		String exColFieldKey = String.valueOf(ParamUtil.getParamValueByType(
				String.valueOf(transfer.get("type")), transfer.get("val"),
				context.getDto()));

		String exColValue = StringUtil.defaultString(
				getParamMap().getOrDefault(exColFieldKey, ""), "");

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> existingList = tm.required(() -> {
			return dao.getDuplicatedList(context.getDto().getTenantId(),
					tableCd, colCd, paramValue, exColCd, exColValue);
		});

		if (existingList == null || existingList.isEmpty()) {
			return true;
		} else {
			return false;
		}
	}

}
