package jp.ill.photon.module.validation;

import java.util.List;
import java.util.Map;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

import org.seasar.doma.jdbc.tx.TransactionManager;

public class DuplicateUserChargeValidationModule
		extends AbstractValidationModule {

	@SuppressWarnings("unchecked")
	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

	    if (paramValue == null || paramValue.isEmpty()) {
            return true;
        }

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		boolean result = tm.required(() -> {

		    // 重複判定を loginId で行うか mail で行うかパラメータから取得
	        Map<String, Object> checkParamTransfer = (Map<String, Object>) ruleParams
	                .getOrDefault("check_param", null);
	        String checkParam = "";
	        if (checkParamTransfer != null) {
	            checkParam = String.valueOf(ParamUtil.getParamValueByType(
	                    String.valueOf(checkParamTransfer.get("type")),
	                    checkParamTransfer.get("val"), context.getDto()));
	        }

		    List<Map<String, Object>> userChargeList = null;
	        List<Map<String, Object>> newMemberList = null;

    		// チェックパラメータでSQLの引数を変える
    		if ("loginId".equals(checkParam)) {
    			userChargeList = dao.selectUserCharge(
    					context.getDto().getTenantId(), null, paramValue, "");
    		} else {
    			userChargeList = dao.selectUserCharge(
    					context.getDto().getTenantId(), null, "", paramValue);
    		}

    	    if ("loginId".equals(checkParam)) {
    	        newMemberList = dao.selectNewMemberApproval(
    	                context.getDto().getTenantId(), null, paramValue, "");
    	    } else {
    	        newMemberList = dao.selectNewMemberApproval(
                        context.getDto().getTenantId(), null, "", paramValue);
    	    }

    	    if ( (userChargeList == null || userChargeList.isEmpty()) && (newMemberList == null || newMemberList.isEmpty()) ) {
                // OK
                return true;
            } else {
                // NG
                return false;
            }
		});

		return result;

	}
}
