package jp.ill.photon.module.validation;

import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.ParamUtil;

public class DuplicateAdminUserValidationModule
		extends AbstractValidationModule {

	@SuppressWarnings("unchecked")
	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		// 管理者IDをパラメータから取得
		Map<Object, Object> transfer = (Map<Object, Object>) ruleParams
				.getOrDefault("admin_cd", "");
		String adminCd = String.valueOf(ParamUtil.getParamValueByType(
				String.valueOf(transfer.get("type")), transfer.get("val"),
				context.getDto()));

		// 重複判定を loginId で行うか mail で行うかパラメータから取得
		Map<String, Object> checkParamTransfer = (Map<String, Object>) ruleParams
				.getOrDefault("check_param", null);
		String checkParam = "";
		if (checkParamTransfer != null) {
			checkParam = String.valueOf(ParamUtil.getParamValueByType(
					String.valueOf(checkParamTransfer.get("type")),
					checkParamTransfer.get("val"), context.getDto()));
		}

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();
		List<Map<String, Object>> adminUserList = null;

		// チェックパラメータでSQLの引数を変える
		if ("loginId".equals(checkParam)) {
			adminUserList = tm.required(() -> {
				return dao.selectAdminUser(context.getDto().getTenantId(),
						adminCd, paramValue, "");
			});
		} else {
			adminUserList = tm.required(() -> {
				return dao.selectAdminUser(context.getDto().getTenantId(),
						adminCd, "", paramValue);
			});
		}

		if (adminUserList == null || adminUserList.isEmpty()) {
			// OK
			return true;

		} else {
			// NG
			return false;

		}
	}
}
