package jp.ill.photon.module.validation;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.DateFormatCheckUtil;
import jp.ill.photon.util.ParamUtil;

/**
 * 日付フォーマットバリデーション
 * 日付/日時/時刻 のフォーマットチェック
 *
 * @author y_hirota
 *
*/
public class DateFormatValidationModule extends AbstractValidationModule {

	public boolean validate(String paramName,
			Map<String, Object> ruleParams,
			String paramValue,
			ModuleContext context) {

		// 日付フォーマット区分を取得
		Map<String, Object> datetimeFormatDiv = autoCast(ruleParams.get("date_format_div"));
		String valueDatetimeFormatDiv = StringUtils.defaultString(ParamUtil.getParamStrValueByType(datetimeFormatDiv, context.getDto()), "");

		// 日付フォーマットチェック
		if(!DateFormatCheckUtil.dateFormatCheck(valueDatetimeFormatDiv, paramValue)){
			return false;
		}
		return true;
	}

	/** Object型を自動キャスト */
	@SuppressWarnings("unchecked")
	public static <T> T autoCast(Object obj) {
	    T castObj = (T) obj;
	    return castObj;
	}
}
