package jp.ill.photon.module.validation;

import java.util.Map;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.DateCheckUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

/**
 * 日付比較バリデーション
 *
 * @author y_hirota
 *
 */
public class DateComparatorValidationModule extends AbstractValidationModule {

	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		String defaultDate = "1900/01/01";
		String defaultTime = "00:00";

		// 基準日時
		String baseDateTime = StringUtil.defaultString(
				getActionParams().getOrDefault("base_datetime", ""), "");

		if (baseDateTime == null || baseDateTime.equals("")) {
			// 基準日付
			String baseDate = StringUtil.defaultString(
					getActionParams().getOrDefault("base_date", defaultDate),
					defaultDate);
			if (UtilTools.isEmpty(baseDate)) {
				baseDate = defaultDate;
			}

			// 基準時間
			String baseTime = StringUtil.defaultString(
					getActionParams().getOrDefault("base_time", defaultTime),
					defaultTime);
			if (UtilTools.isEmpty(baseTime)) {
				baseTime = defaultTime;
			}

			baseDateTime = baseDate + " " + baseTime;
			baseDateTime = baseDateTime.trim();
		}

		// 基準日時
		String targetDateTime = StringUtil.defaultString(
				getActionParams().getOrDefault("target_datetime", ""), "");

		if (targetDateTime == null || targetDateTime.equals("")) {
			// 比較日付
			String targetDate = StringUtil.defaultString(
					getActionParams().getOrDefault("target_date", defaultDate),
					defaultDate);
			if (UtilTools.isEmpty(targetDate)) {
				targetDate = defaultDate;
			}

			// 比較時刻
			String targetTime = StringUtil.defaultString(
					getActionParams().getOrDefault("target_time", defaultTime),
					defaultTime);
			if (UtilTools.isEmpty(targetTime)) {
				targetTime = defaultTime;
			}

			targetDateTime = targetDate + " " + targetTime;
			targetDateTime = targetDateTime.trim();
		}

		// 比較演算子
		String operatorType = StringUtil.defaultString(
				getActionParams().getOrDefault("operator_type", "=="), "==");

		// どちらかが空なら比較不要
		if (UtilTools.isEmpty(baseDateTime)
				|| UtilTools.isEmpty(targetDateTime)) {
			return true;
		}

		// 日付チェック
		if (!DateCheckUtil.dateCheck(baseDateTime, targetDateTime,
				operatorType)) {
			return false;
		}

		return true;
	}

	/** Object型を自動キャスト */
	@SuppressWarnings("unchecked")
	public static <T> T autoCast(Object obj) {
		T castObj = (T) obj;
		return castObj;
	}
}
