package jp.ill.photon.module.validation;

import java.io.BufferedReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.StringUtil;

/**
 * CSVファイルの1行目の重複をチェックするモジュール
 * 
 * @author h_tanaka
 *
 */
public class CsvFileDuplicatedColumnValidationModule
		extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {

		String filePath = StringUtil.defaultString(paramValue, "");

		if (filePath == "") {
			return false;
		}

		String fileEncoding = StringUtil.defaultString(
				getActionParams().getOrDefault("file_encoding", "UTF-8"),
				"UTF-8");
		String delimiter = StringUtil.defaultString(
				getActionParams().getOrDefault("delimiter", ","), ",");

		Path path = Paths.get(filePath);

		List<String> columnList = null;
		try (BufferedReader br = Files.newBufferedReader(path,
				Charset.forName(fileEncoding))) {
			String line = null;
			if ((line = br.readLine()) != null) {
				columnList = csvLineToList(line, delimiter);
			}
		} catch (Exception e) {
		}

		if (columnList == null) {
			return true;
		}

		Map<String, Integer> columnCountMap = new HashMap<>();
		for (String column : columnList) {
			if (!columnCountMap.containsKey(column)) {
				columnCountMap.put(column, 1);
			} else {
				columnCountMap.put(column, columnCountMap.get(column) + 1);
			}
		}

		List<String> duplicatedColumns = new ArrayList<>();
		for (Map.Entry<String, Integer> entry : columnCountMap.entrySet()) {
			if (entry.getValue() > 1) {
				duplicatedColumns.add(entry.getKey());
			}
		}

		getValidateResults().put("columns",
				duplicatedColumns.stream().collect(Collectors.joining(",")));

		return (duplicatedColumns.size() == 0);
	}

	/**
	 * CSV行データをListに変換
	 * 
	 * @param line
	 * @return
	 */
	protected List<String> csvLineToList(String line, String delimiter) {
		List<String> dataList = Arrays.stream(line.split(delimiter))
				.collect(Collectors.toList());

		return dataList;
	}
}
