package jp.ill.photon.module.validation;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.model.AoSetting;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.AoFormatCheckUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;

public class AoQuantityByCaseFormatValidationModule
		extends AbstractValidationModule {

	@Override
	public boolean validate(String paramName,
							Map<String, Object> ruleParams,
							String paramValue,
							ModuleContext context) {
		// AO設定取得
		Map<String, Object> aoSettingMap = autoCast(
				context.getDto().get("common", "aladdinsetting"));
		AoSetting aoSetting = AoSetting.valueOf(aoSettingMap);

		// AOフォーマット区分を取得
		Map<String, Object> aoFormatDiv = autoCast(
				ruleParams.get("ao_format_div"));
		String valudAoFormatDiv = StringUtil.defaultString(
				ParamUtil.getParamStrValueByType(aoFormatDiv, context.getDto()),
				"");

		// 入数を取得
		Map<String, Object> quantityPerCaseParam = autoCast(
				ruleParams.getOrDefault("quantity_per_case", ""));
		BigDecimal quantityPerCase = null;
		try {
			quantityPerCase = new BigDecimal(
					StringUtil.defaultString(
							ParamUtil.getParamStrValueByType(
									quantityPerCaseParam, context.getDto()),
							"0"));
		} catch (Exception e) {
			quantityPerCase = BigDecimal.ZERO;
		}

		BigDecimal value = null;
		try {
			value = new BigDecimal(paramValue);
		} catch (Exception e) {
			value = BigDecimal.ZERO;
		}

		// AOフォーマットチェック
		if (!AoFormatCheckUtil.aoFormatCheck(valudAoFormatDiv,
				quantityPerCase.multiply(value).toString(), aoSetting)) {
			return false;
		}
		return true;
	}

	/** Object型を自動キャスト */
	@SuppressWarnings("unchecked")
	public static <T> T autoCast(Object obj) {
		T castObj = (T) obj;
		return castObj;
	}
}
