package jp.ill.photon.module.validation;

import java.util.HashMap;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

@ModuleVersion("1.0.0")
public abstract class AbstractValidationModule implements PhotonModule {

	@ModuleParam(required = true)
	private String paramName;

	@ModuleParam(required = true)
	private Map<String, Object> ruleParams;

	@ModuleParam(required = true)
	private Map<String, Object> actionParams;

	@ModuleParam(required = true)
	private String paramValue;

	@ModuleParam(required = false)
	private Object paramRawValue;

	@ModuleParam(required = true)
	private String message;

	/**
	 * 結果キャッシュ利用可否
	 */
	@ModuleParam(required = false)
	private boolean isCacheable;

	private Map<String, Object> validateResults;

	private Map<String, Object> paramMap;

	/**
	 * 結果キャッシュ用マップ
	 */
	private Map<String, Object> resultCacheMap;

	public String getParamName() {
		return paramName;
	}

	public void setParamName(String paramName) {
		this.paramName = paramName;
	}

	public Map<String, Object> getRuleParams() {
		return ruleParams;
	}

	public void setRuleParams(Map<String, Object> ruleParams) {
		this.ruleParams = ruleParams;
	}

	public Map<String, Object> getActionParams() {
		if (actionParams == null) {
			actionParams = new HashMap<String, Object>();
		}
		return actionParams;
	}

	public void setActionParams(Map<String, Object> actionParams) {
		this.actionParams = actionParams;
	}

	public String getParamValue() {
		return paramValue;
	}

	public void setParamValue(String paramValue) {
		this.paramValue = paramValue;
	}

	public Object getParamRawValue() {
		return paramRawValue;
	}

	public void setParamRawValue(Object paramRawValue) {
		this.paramRawValue = paramRawValue;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 *
	 * @param paramName 対象パラメータ名
	 * @param ruleParams ルール用パラメータ
	 * @param paramValue 対象入力値
	 * @param context コンテキスト
	 * @return バリデート結果
	 */
	public abstract boolean validate(	String paramName,
										Map<String, Object> ruleParams,
										String paramValue,
										ModuleContext context);

	public boolean validateObjectValue(	String paramName,
										Map<String, Object> ruleParams,
										Object paramValue,
										ModuleContext context) {
		return true;
	}

	@Override
	public ModuleResult execute(ModuleContext context) {

		boolean validateResult = (paramRawValue != null)
				? validateObjectValue(paramName, ruleParams, paramRawValue,
						context)
				: validate(paramName, ruleParams, paramValue, context);

		ModuleResult result = new ModuleResult();
		if (validateResult) {
			result.setResultType(ModuleResult.ResultTypes.CONTINUE);
		} else {
			result.setResultCode("failed");
			result.setResultType(ModuleResult.ResultTypes.ERROR);
			result.getReturnData().put("message", message);
			result.getReturnData().put("validate_results",
					getValidateResults());
		}

		return result;
	}

	public Map<String, Object> getValidateResults() {
		if (validateResults == null) {
			validateResults = new HashMap<>();
		}
		return validateResults;
	}

	public void setValidateResults(Map<String, Object> validateResults) {
		this.validateResults = validateResults;
	}

	public Map<String, Object> getParamMap() {
		if (paramMap == null) {
			paramMap = new HashMap<>();
		}
		return paramMap;
	}

	public void setParamMap(Map<String, Object> paramMap) {
		this.paramMap = paramMap;
	}

	public boolean isCacheable() {
		return isCacheable;
	}

	public void setCacheable(boolean isCacheable) {
		this.isCacheable = isCacheable;
	}

	public Map<String, Object> getResultCacheMap() {
		return resultCacheMap;
	}

	public void setResultCacheMap(Map<String, Object> resultCacheMap) {
		this.resultCacheMap = resultCacheMap;
	}

}
