package jp.ill.photon.module.systemsetting;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.seasar.doma.jdbc.command.UpdateCommand;
import org.seasar.doma.jdbc.query.UpdateQuery;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.action.FileParam;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.doma.SqlUpdateQueryFactory;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.module.file.FileCopyModule;
import jp.ill.photon.module.file.FileDeleteModule;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

public class BasicSetupUpdateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@ModuleParam(required = true)
	private String execType;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
	private String sqlFileDirPath;

	@ModuleParam(required = false)
	private String userName;

	@ModuleParam(required = false)
	private List<Map<String, Object>> excludeKeyMapList;

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ActionDto dto = context.getDto();
		ModuleResult moduleResult = new ModuleResult();

		Map<String, Object> common = (Map<String, Object>) dto.getDataMap()
				.get("common");
		Map<String, Object> systemSettingMap = (Map<String, Object>) common
				.get("systemsetting");

		// 除外キーリスト作成
		List<String> excludeKeyList = null;
		if (!CollectionUtils.isEmpty(excludeKeyMapList)) {
			excludeKeyList = new ArrayList<String>();
			for (Map<String, Object> mp : excludeKeyMapList) {
				excludeKeyList.add(ParamUtil.getParamStrValueByType(mp, dto));
			}
		}

		Map<String, Object> params = new LinkedHashMap<String, Object>();
		// 入力値をマップにする
		if (paramJson != null) {
			Map<String, String> paramInfo = null;
			for (Map.Entry<String, Object> input : paramJson.entrySet()) {
				paramInfo = (Map) input.getValue();
				params.put(input.getKey(), ParamUtil.getParamValueByType(
						paramInfo.get("type"), paramInfo.get("val"), dto));
			}
		}

		String commonsiteLogoImgDir = (String) ((Map<String, Object>) systemSettingMap
				.get("siteLogoImgDir")).get("note");
		String commonsiteLogoImgPath = (String) ((Map<String, Object>) systemSettingMap
				.get("siteLogoImgPath")).get("note");
		String commonMainteLogoImgDir = (String) ((Map<String, Object>) systemSettingMap
				.get("mainteLogoImgDir")).get("note");
		String commonMainteLogoImgPath = (String) ((Map<String, Object>) systemSettingMap
				.get("mainteLogoImgPath")).get("note");
		String commonMyCompanyLogoImgDir = (String) ((Map<String, Object>) systemSettingMap
				.get("myCompanyLogoImgDir")).get("note");
		String commonMyCompanyLogoImgPath = (String) ((Map<String, Object>) systemSettingMap
				.get("myCompanyLogoImgPath")).get("note");
		String siteLogoImgPath = (String) params.get("siteLogoImgPath");
		String mainteLogoImgPath = (String) params.get("mainteLogoImgPath");
		String myCompanyLogoImgPath = (String) params
				.get("myCompanyLogoImgPath");

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		/** サイトロゴ画像のファイル操作 */
		String siteLogoImageDelFlg = (String) params
				.get("siteLogoImageDelFlg");
		if (siteLogoImageDelFlg != null && "1".equals(siteLogoImageDelFlg)) {
			// サイトロゴ画像の削除
			params.put("siteLogoImgPath", "");

			if (!UtilTools.isEmpty(commonsiteLogoImgDir)
					&& !UtilTools.isEmpty(commonsiteLogoImgPath)) {
				FileDeleteModule filedeleteModule = new FileDeleteModule();
				filedeleteModule.setDirPath(commonsiteLogoImgDir);
				filedeleteModule.setFileName(commonsiteLogoImgPath);
				filedeleteModule.execute(context);
			}

		} else {

			// サイトロゴ画像のアップロード
			FileParam siteLogoImageParam = dto.getParams()
					.getFile("basicSetup.siteLogoImage");
			if (siteLogoImageParam != null) {
				File siteLogoImage = siteLogoImageParam.getFile();

				if (siteLogoImage != null
						&& !UtilTools.isEmpty(commonsiteLogoImgDir)
						&& !UtilTools.isEmpty(siteLogoImgPath)) {
					FileCopyModule fileCopyModule = new FileCopyModule();
					fileCopyModule.setSrcFilePath(siteLogoImage.getPath());
					fileCopyModule.setDestDirPath(commonsiteLogoImgDir);
					fileCopyModule.setDestFilePath(siteLogoImgPath);
					fileCopyModule.execute(context);
				}
			}
		}

		/** メンテナンス画像のファイル操作 */
		String mainteLogoImageDelFlg = (String) params
				.get("mainteLogoImageDelFlg");
		if (mainteLogoImageDelFlg != null
				&& "1".equals(mainteLogoImageDelFlg)) {
			// メンテナンス画像の削除
			params.put("mainteLogoImgPath", "");

			if (!UtilTools.isEmpty(commonMainteLogoImgDir)
					&& !UtilTools.isEmpty(commonMainteLogoImgPath)) {
				FileDeleteModule filedeleteModule = new FileDeleteModule();
				filedeleteModule.setDirPath(commonMainteLogoImgDir);
				filedeleteModule.setFileName(commonMainteLogoImgPath);
				filedeleteModule.execute(context);
			}

		} else {

			// メンテナンス画像のアップロード
			FileParam mainteLogoImageParam = dto.getParams()
					.getFile("basicSetup.mainteLogoImage");
			if (mainteLogoImageParam != null) {
				File mainteLogoImage = mainteLogoImageParam.getFile();

				if (mainteLogoImage != null
						&& !UtilTools.isEmpty(commonMainteLogoImgDir)
						&& !UtilTools.isEmpty(mainteLogoImgPath)) {
					FileCopyModule fileCopyModule = new FileCopyModule();
					fileCopyModule.setSrcFilePath(mainteLogoImage.getPath());
					fileCopyModule.setDestDirPath(commonMainteLogoImgDir);
					fileCopyModule.setDestFilePath(mainteLogoImgPath);
					fileCopyModule.execute(context);
				}
			}
		}

		/** 自社情報ロゴ画像のファイル操作 */
		String myCompanyLogoImageDelFlg = (String) params
				.get("myCompanyLogoImageDelFlg");
		if (myCompanyLogoImageDelFlg != null
				&& "1".equals(myCompanyLogoImageDelFlg)) {
			// 自社情報ロゴ画像の削除
			params.put("myCompanyLogoImgPath", "");

			if (!UtilTools.isEmpty(commonMyCompanyLogoImgDir)
					&& !UtilTools.isEmpty(commonMyCompanyLogoImgPath)) {
				FileDeleteModule filedeleteModule = new FileDeleteModule();
				filedeleteModule.setDirPath(commonMyCompanyLogoImgDir);
				filedeleteModule.setFileName(commonMyCompanyLogoImgPath);
				filedeleteModule.execute(context);
			}

		} else {

			// 自社情報ロゴ画像のアップロード
			FileParam myCompanyLogoImageParam = dto.getParams()
					.getFile("basicSetup.myCompanyLogoImage");
			if (myCompanyLogoImageParam != null) {
				File myCompanyLogoImage = myCompanyLogoImageParam.getFile();

				if (myCompanyLogoImage != null
						&& !UtilTools.isEmpty(commonMyCompanyLogoImgDir)
						&& !UtilTools.isEmpty(myCompanyLogoImgPath)) {
					FileCopyModule fileCopyModule = new FileCopyModule();
					fileCopyModule.setSrcFilePath(myCompanyLogoImage.getPath());
					fileCopyModule.setDestDirPath(commonMyCompanyLogoImgDir);
					fileCopyModule.setDestFilePath(myCompanyLogoImgPath);
					fileCopyModule.execute(context);
				}
			}
		}

		// 登録/変更日時
		String nowDatetime = SQLUtil.getNowDatetime();
		String loginUserName = SQLUtil.getLoginAdminUserName(dto);
		String tenantId = StringUtil.defaultString(params.get("tenantId"));

		if ("update".equals(execType)) {

			/** システム設定テーブルの更新 */
			SqlUpdateQueryFactory updateFactory = SqlUpdateQueryFactory
					.newInstance();

			for (String id : params.keySet()) {
				String note = StringUtil.escapeJsonStr((String) params.get(id));
				HashMap<String, Object> updateSystemSettingParamMap = SQLUtil
						.createUpdateSystemSettingParams(tenantId, id, note,
								nowDatetime, loginUserName);
				UpdateQuery updateNewsInfoQuery = updateFactory
						.createUpdateQueryFromFile(updateSystemSettingParamMap,
								context.getDto(), sqlFileDirPath,
								"aec20/systemsetting/updateSystemSetting.sql");
				updateNewsInfoQuery.prepare();

				// 更新処理を実行
				int result = tm.required(() -> {
					UpdateCommand command = new UpdateCommand(
							updateNewsInfoQuery);
					return command.execute();
				});
			}

		} else if ("merge".equals(execType)) {

			String editTableCd = "systemsetting";

			List<String> list = (excludeKeyList == null) ? null
					: new ArrayList<String>(excludeKeyList);

			int result = tm.required(() -> {

				Map<String, Object> key = dao.getKeyColumns(tenantId,
						editTableCd);

				// 除外キーリストがない場合は、全件通す
				// 除外キーリストがセットされていて、かつ、今参照しているキーが除外キーリスト中に存在していれば、
				// そのキーはmerge処理を行わない
				for (String id : params.keySet()) {

					if (CollectionUtils.isEmpty(list)
							|| (!CollectionUtils.isEmpty(list)
									&& !list.contains(id))) {

						Map<String, Object> mp = new HashMap<String, Object>() {
							{
								put("id", id);
								put("note", StringUtil.escapeJsonStr(
										(String) params.get(id)));
							}
						};

						// キーが存在するものはUPDATE、しないものはINSERTする。
						dao.updateMergeEditTableData(tenantId, editTableCd,
								userName, JsonUtil.mapToJson(mp),
								(String) key.get("val"));

					}

				}

				return 0;

			});

		}

		return moduleResult;
	}

	/**
	 * paramJsonを取得します。
	 *
	 * @return paramJson
	 */
	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	/**
	 * paramJsonを設定します。
	 *
	 * @param paramJson
	 */
	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

	/**
	 * sqlFileDirPathを取得します。
	 *
	 * @return sqlFileDirPath
	 */
	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	/**
	 * sqlFileDirPathを設定します。
	 *
	 * @param sqlFileDirPath
	 */
	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

	/**
	 * execTypeを取得します。
	 *
	 * @return execType
	 */
	public String getExecType() {
		return execType;
	}

	/**
	 * execTypeを設定します。
	 *
	 * @param execType
	 */
	public void setExecType(String execType) {
		this.execType = execType;
	}

	/**
	 * userNameを取得します。
	 *
	 * @return userName
	 */
	public String getUserName() {
		return userName;
	}

	/**
	 * userNameを設定します。
	 *
	 * @param userName
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}

	/**
	 * excludeKeyMapListを取得します。
	 *
	 * @return excludeKeyMapList
	 */
	public List<Map<String, Object>> getExcludeKeyMapList() {
		return excludeKeyMapList;
	}

	/**
	 * excludeKeyMapListを設定します。
	 *
	 * @param excludeKeyMapList
	 */
	public void setExcludeKeyMapList(List<Map<String, Object>> excludeKeyMapList) {
		this.excludeKeyMapList = excludeKeyMapList;
	}

}
