package jp.ill.photon.module.systemsetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.model.ComboBoxItem;
import jp.ill.photon.model.MultiCheckBoxItem;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

public class BasicSetupFormCreateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@Override
	public ModuleResult execute( ModuleContext context ) {

		ModuleResult result = new ModuleResult();

		ActionDto dto = context.getDto();
		ActionParamMap params = dto.getParams();
		/** 結果区分 */
		String resultDiv = (String) params.get("resultDiv");

		/** システム設定テーブルのデータからフォーム(basic_setup_form) データを作成 */
		Map<String, Object> common = (Map<String, Object>) dto.getDataMap().get("common");
		Map<String, Object> systemSettingMap = (Map<String, Object>) common.get("systemsetting");
		Map<String, String> paramInfo = null;
		for (Map.Entry<String, Object> setting : systemSettingMap.entrySet()) {
			paramInfo = (Map) setting.getValue();
			result.getReturnData().put(paramInfo.get("id"), paramInfo.get("note"));
		}

		/** バリデーションエラー時は入力値を設定 */
		// 入力値ではなく初期値を設定する項目リスト
		ArrayList<String> initValueIdList = new ArrayList<String>();
		initValueIdList.add("siteLogoImgPath");
		initValueIdList.add("mainteLogoImgPath");
		initValueIdList.add("myCompanyLogoImgPath");

		if("validation_error".equals(resultDiv)){
			if (params != null) {
				Map<String, String> inputData = null;
				for (Map.Entry<String, Object> setting : systemSettingMap.entrySet()) {
					inputData = (Map) setting.getValue();
					String id = inputData.get("id");
					if(params.getParams().get(id) != null && !initValueIdList.contains(id)){
						String inputVal = params.getParams().get(id)[0];
						result.getReturnData().put(id, inputVal);
					}
				}
			}
		}

		/** パスワード入力チェック */
		result.getReturnData().put("pwTypeList", PwType.PW_TYPE_LIST);

		/** 商品分類表示 */
		ArrayList<MultiCheckBoxItem> shohinCategoryList = createShohinCategoryList(context.getDto());
		result.getReturnData().put("shohinCategoryList", shohinCategoryList);

		/** 決済方法許可表示 */
		ArrayList<MultiCheckBoxItem> paymentList = createPaymentList(context.getDto());
		result.getReturnData().put("paymentList", paymentList);

		return result;
	}

	/** パスワード入力チェック */
	public static class PwType {
		/** 半角英字のみ */
		public static final String TYPE_1 = "0";
		/** 半角英数字のみ */
		public static final String TYPE_2 = "1";
		/** 半角英字、数字いずれも含む */
		public static final String TYPE_3 = "2";
		/** 半角英小文字、半角英大文字、数字いずれも含む */
		public static final String TYPE_4 = "3";
		/** 半角英数記号のみ */
		public static final String TYPE_5 = "4";
		/** 半角英数記号のみでいずれも含む */
		public static final String TYPE_6 = "5";
		/** 半角英数記号のみで英小文字、大文字、数字、記号いずれも含む */
		public static final String TYPE_7 = "6";
		/** コンボボックス項目リスト */
		public static final ArrayList<ComboBoxItem> PW_TYPE_LIST = new ArrayList<ComboBoxItem>();
		static {
			PW_TYPE_LIST.add(new ComboBoxItem(TYPE_1, "半角英字のみ"));
			PW_TYPE_LIST.add(new ComboBoxItem(TYPE_2, "半角英数字のみ"));
			PW_TYPE_LIST.add(new ComboBoxItem(TYPE_3, "半角英数字のみでいずれも含む"));
			PW_TYPE_LIST.add(new ComboBoxItem(TYPE_4, "半角英数字のみで英小文字、大文字、数字いずれも含む"));
			PW_TYPE_LIST.add(new ComboBoxItem(TYPE_5, "半角英数記号のみ"));
			PW_TYPE_LIST.add(new ComboBoxItem(TYPE_6, "半角英数記号のみでいずれも含む"));
			PW_TYPE_LIST.add(new ComboBoxItem(TYPE_7, "半角英数記号のみで英小文字、大文字、数字、記号いずれも含む"));
		}
	}

	/** 商品分類チェックボックスを生成 */
	@SuppressWarnings("unchecked")
	public ArrayList<MultiCheckBoxItem> createShohinCategoryList( ActionDto dto ){

		ArrayList<MultiCheckBoxItem> shohinCategyList = new ArrayList<MultiCheckBoxItem>();
		List<Map<String, Object>> shohinCategyMap = getLabelListShohinCategory(dto);

		int category_no = 1;
		for(Map<String, Object> sc: shohinCategyMap){
			String id = "basicSetup_itemCategory" + category_no + "DispFlg";
			String name = "basicSetup.itemCategory" + category_no + "DispFlg";
			Map<String, Object> systemsetting = (Map<String, Object>) ((Map<String, Object>) dto.getDataMap().get("common")).get("systemsetting");
			Map<String, Object> rec = (Map<String, Object>) systemsetting.get("itemCategory" + category_no + "DispFlg");
			String dispFlg = (String) rec.get("note");
			String checked = "1".equals(dispFlg)? "true" : "false";
			String note = (String) sc.get("note");
			shohinCategyList.add(new MultiCheckBoxItem(id, name, "1", checked, note));
			category_no++;
		}

		return shohinCategyList;
	}

	/** 商品分類リストを取得 */
	public List<Map<String, Object>> getLabelListShohinCategory( ActionDto dto ) {

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> label_data = tm.required(() -> {
			return dao.getLabelListShohinCategory(dto.getTenantId());
		});

		return label_data;
	}

	/**
	 * 決済方法許可チェックボックスを生成します。
	 * @param ActionDto
	 * @return ArrayList<MultiCheckBoxItem>
	 */
	@SuppressWarnings("unchecked")
	public ArrayList<MultiCheckBoxItem> createPaymentList( ActionDto dto ){

		ArrayList<MultiCheckBoxItem> paymentList = new ArrayList<MultiCheckBoxItem>();
		List<Map<String, Object>> paymentMap = getLabelListPayment(dto);

		Map<String, Object> systemsetting = (Map<String, Object>) ((Map<String, Object>) dto.getDataMap().get("common")).get("systemsetting");
		Map<String, Object> paymentDefaultList = (Map<String, Object>) systemsetting.get("paymentDefault");
		String[] paymentDefaultStringList = paymentDefaultList.get("note").toString().split(",");

		int payment_no = 1;
		for(Map<String, Object> sc: paymentMap){

			String dispFlg = (String) sc.get("disp_flg");
			if (!"1".equals(dispFlg)) {
				continue;
			}
			String id = "basicSetup_payment" + payment_no;
			String name = "basicSetup.payment";
			String checked;
			if (Arrays.asList(paymentDefaultStringList).contains(sc.get("payment_cd"))){
				checked = "true";
			} else {
				checked = "false";
			}
			String value = (String) sc.get("payment_cd");
			String note = (String) sc.get("payment_name");

			paymentList.add(new MultiCheckBoxItem(id, name, value, checked, note));
			payment_no++;
		}

		return paymentList;
	}

	/**
	 * 決済方法許可リストを取得します。
	 * @param ActionDto
	 * @return List<Map<String, Object>>
	 */
	public List<Map<String, Object>> getLabelListPayment( ActionDto dto ) {

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> label_data = tm.required(() -> {
			return dao.getPayment(dto.getTenantId());
		});

		return label_data;
	}

	/**
	 * paramJsonを取得します。
	 * @return paramJson
	 */
	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	/**
	 * paramJsonを設定します。
	 * @param paramJson
	 */
	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

}
