package jp.ill.photon.module.shohin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dao.builder.SimpleJSONSelectSQLBuilder;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;

import org.postgresql.util.PGobject;
import org.seasar.doma.jdbc.tx.TransactionManager;

/**
 * 商品検索フォームの初期データを作成する
 *
 * @author h_tanaka
 *
 */
@ModuleVersion("1.0.0")
public class ShohinSearchFormCreateModule implements PhotonModule {



	@Override
	public ModuleResult execute( ModuleContext context ) {

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();
		ModuleResult result = new ModuleResult();

		Map<String, Object> settingParams = (Map<String, Object>) context.getDto()
				.get("common", "systemsetting");

		String stockDispFlg = (settingParams.get("stockDispFlg") != null)
				? String.valueOf(settingParams.get("stockDispFlg")) : "";

		for (int i = 1; i <= 10; i++) {
			result.getReturnData()
					.putAll(createCategorySelectList(i, context.getDto(), tm, dao));
		}

		// TODO ootah: 後で
//		result.getReturnData().putAll(moduleParams.entrySet().stream()
//				.filter(p -> p.getKey().matches("^search_form.*"))
//				.collect(Collectors.toMap(
//						p -> p.getKey().replace("search_form.", ""), p -> String
//								.valueOf(p.getValue()))));

		result.getReturnData().put("sortList",
				getSortList(context.getDto().getTenantId(), "201", stockDispFlg));
		result.getReturnData().put("catalogList", new ArrayList<>());

		return result;
	}

	protected Map<String, Object> createCategorySelectList(	int no,
															ActionDto dto,
															TransactionManager tm,
															JsonDataDao dao) {

		Map<String, Object> returnData = new LinkedHashMap<>();
		String strNo = String.valueOf(no);
		String dispFlg = (String) dto.get(
				"common.systemsetting.itemCategory" + strNo + "DispFlg.note");
		if (dispFlg.equals("0")) {
			returnData.put("cat" + strNo + "_select_list", new ArrayList<>());
		} else {
			List<Map<String, Object>> result = tm.required(() -> {
				return dao.selectShohinCategories(dto.getTenantId(), no);
			});

			List<Map<String, Object>> resultList = new ArrayList<>();
			Map<String, Object> jsonValue = null;
			for (Map<String, Object> row : result) {
				jsonValue = JsonUtil
						.jsonToMap(((PGobject) row.get("val")).getValue());
				resultList.add(jsonValue);
			}
			returnData.put("cat" + strNo + "_select_list", resultList);
		}
		returnData.put("cat" + strNo, null);

		return returnData;
	}

	protected LinkedHashMap<String, String> getSortList(String tenantId,
														String pageDiv,
														String stockDispFlg) {

		List<Map<String, Object>> sqlWhere = new ArrayList<>();
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "page_div");
				put("class", int.class);
				put("value", Integer.parseInt(pageDiv));
			}
		});
		List<Map<String, String>> sqlOrder = new ArrayList<>();
		sqlOrder.add(new HashMap<String, String>() {
			{
				put("key", "sort_no");
				put("dr", "ASC");
			}
		});

		SimpleJSONSelectSQLBuilder builder = new SimpleJSONSelectSQLBuilder();
		List<Map<String, Object>> sorts = builder.getListResult(tenantId,
				"sort", sqlWhere, sqlOrder);

		LinkedHashMap<String, String> sortSelectList = new LinkedHashMap<>();
		for (Map<String, Object> sort : sorts) {
			if (stockDispFlg.equals("0")
					&& ((String) sort.get("option")).equals("stock")) {
			} else {
				sortSelectList.put((String) sort.get("sort_cd"),
						(String) sort.get("disp_name"));
			}
		}

		return sortSelectList;
	}
}
