package jp.ill.photon.module.shohin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.model.ItemSearchForm;
import jp.ill.photon.model.User;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

import org.seasar.doma.jdbc.tx.TransactionManager;

@ModuleVersion("1.0.0")
public class GeneralShohinSearchModule implements PhotonModule {

	@ModuleParam(required=true, domainObject=true)
	private User user;

	@ModuleParam(required=true, paramGroup=true)
	private ItemSearchForm searchForm;

	public GeneralShohinSearchModule() {
		searchForm = new ItemSearchForm();
	}

	public ItemSearchForm getSearchForm() {
		return searchForm;
	}

	public void setSearchForm(ItemSearchForm searchForm) {
		this.searchForm = searchForm;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	@Override
	public ModuleResult execute( ModuleContext context ) {

		ModuleResult result = new ModuleResult();

		List<Map<String, Object>> shohinList = getShohinList(context.getDto());

		int shohinCount = 0;
		if (shohinList.size() > 0) {
			shohinCount = Integer
					.parseInt(String.valueOf(shohinList.get(0).get("count")));
		}

		result.getReturnData().put("shohinList", shohinList);
		result.getReturnData().put("shohinCount", shohinCount);

		return result;
	}

	protected List<Map<String, Object>> getShohinList( ActionDto dto ) {

		String userCd = null;
		if (user != null) {
			userCd = String.valueOf(user.getUserCd());
		}

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		Map<String, String> sqlParams = new HashMap<>();
		// TODO ootah: 後で
//		sqlParams.putAll(mp.entrySet().stream()
//				.filter(p -> p.getKey().matches("^search_form.*"))
//				.collect(Collectors.toMap(p -> p.getKey(),
//						p -> String.valueOf(p.getValue()))));

		sqlParams.put("withTanka", "0");
		sqlParams.put("condStrInTax",
				"TBL_BU.VAL->>$$tax_div$$ = $$2$$ AND (TBL_BI.VAL->>$$tax_bracket_cd$$)::int NOT IN (0, 9)");
		sqlParams.put("condStrNoTax",
				"TBL_BU.VAL->>$$tab_div$$ <> $$2$$ OR (TBL_BI.VAL->>$$tax_bracket_cd$$)::int IN (0, 9)");
		sqlParams.put("userPriceAdoptDiv", "1");
		sqlParams.put("userCd", userCd);
		sqlParams.put("deliveryCd", null);
		sqlParams.put("userActiveItemFlg", "0");
		sqlParams.put("isMemoVisible", "1");
		sqlParams.put("isMemo1Visible", "1");
		sqlParams.put("isMemo2Visible", "1");
		sqlParams.put("isMemo3Visible", "1");
		sqlParams.put("convMemo", "");
		sqlParams.put("stockDiv", "0");
		sqlParams.put("sortQuery", "BI.VAL->>$$item_cd$$ ASC");

		List<Map<String, Object>> shohins = tm.required(() -> {
			return dao.selectShohins(dto.getTenantId(), dto, sqlParams);
		});

		return shohins;
	}
}
