package jp.ill.photon.module.shipped;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * 
 * 出荷時メール送信フラグを非対象にするリストを作成する<br />
 * <br />
 * 入力: <br/>
 * mailContentsSuccessList: 更新対象<br/>
 * <br/>
 * 戻り値: <br />
 * updateList: 更新対象リスト(ArrayList{@literal<Object>})
 * 
 */
@ModuleVersion("1.0.0")
public class CheckShippedMailSendModule implements PhotonModule {

	/** 更新対象 */
	@ModuleParam(required = false)
	private List<Map<String, Object>> mailContentsSuccessList;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		// 返却用配列
		ArrayList<Object> updateList = new ArrayList<Object>();

		for (Map<String, Object> successMap : mailContentsSuccessList) {
			String orderNo = String.valueOf(successMap.get("order_no"));
			updateList.add(orderNo);
		}

		// 結果を返す
		ModuleResult result = new ModuleResult();
		result.getReturnData().put("updateList", updateList);

		return result;
	}

	/**
	 * 更新対象を取得します。
	 * @return 更新対象
	 */
	public List<Map<String,Object>> getMailContentsSuccessList() {
	    return mailContentsSuccessList;
	}

	/**
	 * 更新対象を設定します。
	 * @param mailContentsSuccessList 更新対象
	 */
	public void setMailContentsSuccessList(List<Map<String,Object>> mailContentsSuccessList) {
	    this.mailContentsSuccessList = mailContentsSuccessList;
	}
}
