package jp.ill.photon.module.session;

import javax.servlet.http.HttpSession;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * セッションに値を設定するモジュール
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class SessionSetMultiModule implements PhotonModule {

	@ModuleParam(required = true)
	private String tenantId;

	@ModuleParam(required = true)
	private String[] setName;

	@ModuleParam(required = true)
	private Object[] setValue;

	public String[] getSetName() {
		return setName;
	}

	public void setSetName(String[] setName) {
		this.setName = setName;
	}

	public Object getSetValue() {
		return setValue;
	}

	public void setSetValue(Object[] setValue) {
		this.setValue = setValue;
	}

	/**
	 * セッションに値を設定するメソッド
	 *
	 * @param context コンテキスト
	 * @return モジュール結果クラス
	 *
	 */
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();
		HttpSession session = context.getDto().getSession();

		// 設定値と設定名の配列数が違う場合
		if (setName.length != setValue.length) {
			result.setResultType(ModuleResult.ResultTypes.ERROR);
			return result;
		}

		// セッション設定ループ
		for (int setCnt = 0; setCnt < setName.length; setCnt++) {
			session.setAttribute(setName[setCnt] + "-" + getTenantId(),
					setValue[setCnt]);
		}

		result.setResultType(ModuleResult.ResultTypes.REDIRECT);
		return result;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

}
