package jp.ill.photon.module.session;

import javax.servlet.http.HttpSession;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * セッションに保持するモジュール
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class SessionSetModule implements PhotonModule {

	@ModuleParam(required = true)
	private String tenantId;

	@ModuleParam(required = true)
	private String appId;

	@ModuleParam(required = true)
	private String name;

	@ModuleParam(required = false)
	private Object value;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();
		HttpSession session = context.getDto().getSession();

		// パラメータ情報をセッションに保持する
		session.setAttribute(getName() + "-" + getTenantId() + "-" + getAppId(),
				getValue());
		result.setResultCode("success");

		return result;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

}
