package jp.ill.photon.module.session;

import javax.servlet.http.HttpSession;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.LogUtil;

/**
 * セッションの初期設定を行うモジュール
 *
 * @author h_tanaka
 *
 */
@ModuleVersion("1.0.0")
public class SessionInitModule implements PhotonModule {

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(SessionInitModule.class);

	@ModuleParam(required = true)
	private String tenantId;

	@ModuleParam(required = false)
	private String timeOut;

	/**
	 *
	 * @param context コンテキスト
	 * @return モジュール結果クラス
	 *
	 */
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();
		HttpSession session = context.getDto().getSession();

		// セッションのタイムアウト時間をセット
		String sessionTimeOut = getTimeOut();
		if (sessionTimeOut != null && !sessionTimeOut.equals("")) {
			try {
				session.setMaxInactiveInterval(
						Integer.parseInt(sessionTimeOut));
			} catch (Exception e) {
				logger.error("セッションタイムアウト設定失敗", e);
			}
		}

		return result;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getTimeOut() {
		return timeOut;
	}

	public void setTimeOut(String timeOut) {
		this.timeOut = timeOut;
	}
}
