package jp.ill.photon.module.session;

import javax.servlet.http.HttpSession;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

import org.apache.commons.lang3.StringUtils;

/**
 * 指定したセッションを削除するモジュール
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class SessionIndividualRemoveModule implements PhotonModule {

	@ModuleParam(required = true)
	private String tenantId;

	@ModuleParam(required = true)
	private String appId;

	@ModuleParam(required = false)
	private String judgeFlg;

	@ModuleParam(required = false)
	private String sessionName;

	/**
	 * 指定したセッションを削除するメソッド
	 *
	 * パラメータが空の場合はセッションは削除せず(ResultCode=not_remove)、
	 * パラメータが空以外の場合のみセッションを削除します(ResultCode=remove)。
	 *
	 * @param context コンテキスト
	 * @return モジュール結果クラス
	 *
	 */
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();
		HttpSession session = context.getDto().getSession();

		// パラメータが空の場合
		if (StringUtils.isEmpty(judgeFlg)) {

			result.setResultCode("not_clear");
		} else {
			// パラメータが空以外の場合

			// セッションの破棄
			if (StringUtils.isEmpty(appId)) {
				session.removeAttribute(sessionName + "-" + getTenantId());
			} else {
				session.removeAttribute(sessionName + "-" + getTenantId() + "-" + getAppId());
			}
			result.setResultCode("clear");

		}

		return result;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getJudgeFlg() {
		return judgeFlg;
	}

	public void setJudgeFlg(String judgeFlg) {
		this.judgeFlg = judgeFlg;
	}

	public String getSessionName() {
		return sessionName;
	}

	public void setSessionName(String sessionName) {
		this.sessionName = sessionName;
	}

}
