package jp.ill.photon.module.session;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.model.MapParam;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ParamUtil;

/**
 * セッションから値を取得するモジュール
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class SessionGetModule implements PhotonModule {

	@ModuleParam(required = true)
	private String tenantId;

	@ModuleParam(required = true)
	private String appId;

	@ModuleParam(required = false)
	private MapParam sessionNameList;

	public void setSessionNameList(MapParam sessionNameList) {
		this.sessionNameList = sessionNameList;
	}

	public MapParam getSessionNameList() {
		return sessionNameList;
	}

	/**
	 * セッションから値を取得するメソッド
	 *
	 * @param context コンテキスト
	 * @return モジュール結果クラス
	 *
	 */
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();
		HttpSession session = context.getDto().getSession();

		// パラメータデータを取得
		Map<String, Object> sessionNameValues = new LinkedHashMap<String, Object>();
		for (Map.Entry<String, Object> param : getSessionNameList()
				.getParamMap().entrySet()) {
			String type = String.valueOf(((Map) param.getValue()).get("type"));
			sessionNameValues.put((String) param.getKey(),
					ParamUtil.getParamValueByType(type,
							((Map) param.getValue()).get("val"),
							context.getDto()));
		}

		boolean dataFlg = false;
		if (session != null) {
			// セッション取得ループ
			for (Map.Entry<String, Object> entry : sessionNameValues
					.entrySet()) {
				Object sessionVal = session
						.getAttribute(String.valueOf(entry.getValue()) + "-"
								+ getTenantId() + "-" + getAppId());
				if (sessionVal != null) {
					dataFlg = true;
					if (String.class.equals(sessionVal.getClass())
							&& StringUtils.isEmpty((String) sessionVal)) {
						// セッションの値がnulllもしくは空白の場合
						dataFlg = false;
					}
				}
				result.getReturnData().put(entry.getKey(), sessionVal);
			}

			// セッションリストが０件、もしくはセッションにデータがない場合
			if (getSessionNameList().getParamMap().isEmpty() || !dataFlg) {
				result.setResultCode("no_data");
			} else {
				result.setResultCode("register_data");
			}
		} else {
			result.setResultCode("no_data");
		}
		return result;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

}
